/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.bundle.Resources;
import kd.bos.context.OperationContextCreator;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.datasource.DataSourceInfoCreator;
import kd.bos.db.datasource.DataSourceInfoGroup;
import kd.bos.db.datasource.DataSourceType;
import kd.bos.db.extension.DBExtensionsRegister;
import kd.bos.env.EnvContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ksql.CONSTANT;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.exception.ExceptionUtil;

class DataSourceCreateService {
    private static ExecutorService es = Executors.newCachedThreadPool(new ThreadFactory(){
        private AtomicInteger seq = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "pool-create-datasource-thread-" + this.seq.getAndIncrement());
        }
    });
    private static Map<String, AccountDataSourceGroup> accountGroupMap = new ConcurrentHashMap<String, AccountDataSourceGroup>();
    private static int ts_timeout = 300;

    DataSourceCreateService() {
    }

    static Map<String, DataSourceInfoGroup> toPlatGroupMap() {
        HashMap<String, DataSourceInfoGroup> ret = new HashMap<String, DataSourceInfoGroup>();
        for (String accountKey : new ArrayList<String>(accountGroupMap.keySet())) {
            AccountDataSourceGroup accountDataSourceGroup = accountGroupMap.get(accountKey);
            for (String route : accountDataSourceGroup.routeGroupMap.keySet()) {
                ret.put(accountKey + '#' + route, (DataSourceInfoGroup)accountDataSourceGroup.routeGroupMap.get(route));
            }
        }
        return ret;
    }

    static Map<String, DataSourceInfoGroup> getAccountGroupMap(String tenantId, String accountId) {
        String accountKey = tenantId + '#' + accountId;
        return accountGroupMap.computeIfAbsent(accountKey, k -> new AccountDataSourceGroup()).routeGroupMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DataSourceInfoGroup getOrCreateGroup(String tenantId, String accountId, String routeKey, Properties defaultProps, DataSourceType dataSourceType, Supplier<List<DBConfig>> dbConfigSupplier) {
        String accountKey = tenantId + '#' + accountId;
        AccountDataSourceGroup accountGroup = accountGroupMap.get(accountKey);
        if (accountGroup == null) {
            accountGroup = accountGroupMap.computeIfAbsent(accountKey, k -> new AccountDataSourceGroup());
        }
        Map routeGroupMap = accountGroup.routeGroupMap;
        List<DBConfig> confs = dbConfigSupplier == null ? DBExtensionsRegister.getDBConfigs(tenantId, routeKey, accountId, false) : dbConfigSupplier.get();
        try {
            if (confs.isEmpty()) {
                DBRoute dbRoute = DBRoute.of(routeKey);
                if (!dbRoute.isRoot()) {
                    String string = dbRoute.parent().getRouteKey();
                    return DataSourceCreateService.getOrCreateGroup(tenantId, accountId, string, defaultProps, dataSourceType, dbConfigSupplier);
                }
                String string = Resources.get((String)"bos-dbengine", (String)"DataSourceCreateService_1", (String)"\u6570\u636e\u4e2d\u5fc3\u672a\u914d\u7f6e\u6570\u636e\u6e90: tenantId=", (Object[])new Object[0]) + tenantId + ", accountId=" + accountId + ", routeKey=" + routeKey;
                throw new Exception(string);
            }
        }
        catch (Exception e) {
            void var11_17;
            Exception exception = e;
            if (!(e instanceof ExecutionException)) throw ExceptionUtil.asRuntimeException((Throwable)var11_17);
            Throwable throwable = e.getCause();
            throw ExceptionUtil.asRuntimeException((Throwable)var11_17);
        }
        List sortedSharingIds = confs.stream().map(c -> c.getSharingId()).sorted().collect(Collectors.toList());
        String string = String.join((CharSequence)"&", sortedSharingIds);
        String sharingRouteKeyObj = accountKey + '#' + string;
        RouteLockObject routeLockObject = (RouteLockObject)accountGroup.routeLockObjectMap.get(sharingRouteKeyObj);
        if (routeLockObject == null) {
            routeLockObject = accountGroup.routeLockObjectMap.computeIfAbsent(sharingRouteKeyObj, k -> new RouteLockObject());
        }
        try {
            if (!routeLockObject.r.tryLock(ts_timeout + 10, TimeUnit.SECONDS)) throw new RuntimeException(Resources.get((String)"bos-dbengine", (String)"DataSourceCreateService_0", (String)"\u7b49\u5f85\u8fde\u63a5\u6c60\u521b\u5efa\u8d85\u65f6(>", (Object[])new Object[0]) + ts_timeout * 2 + "s): tenantId=" + tenantId + ", accountId=" + accountId + ", routeKey=" + routeKey);
            try {
                DataSourceInfoGroup dsg = (DataSourceInfoGroup)routeGroupMap.get(routeKey);
                if (dsg != null) {
                    DataSourceCreateService.changeDBConfig(dsg, tenantId, accountId, routeKey);
                    DataSourceInfoGroup dataSourceInfoGroup = dsg;
                    return dataSourceInfoGroup;
                }
            }
            finally {
                routeLockObject.r.unlock();
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
        EnvContext ctx = EnvContext.thread();
        String appId = (String)ctx.get("appId");
        String formId = (String)ctx.get("formId");
        String formName = (String)ctx.get("formname");
        RouteLockObject final_routeLockObject = routeLockObject;
        Future<Object> f = es.submit(() -> {
            DataSourceInfoGroup dsg = (DataSourceInfoGroup)routeGroupMap.get(routeKey);
            if (dsg != null) {
                DataSourceCreateService.changeDBConfig(dsg, tenantId, accountId, routeKey);
                return dsg;
            }
            new RequestContextInfo(tenantId, accountId).setupThreadRequestContext();
            final_routeLockObject.w.lock();
            try {
                dsg = (DataSourceInfoGroup)routeGroupMap.get(routeKey);
                if (dsg != null) {
                    DataSourceCreateService.changeDBConfig(dsg, tenantId, accountId, routeKey);
                    DataSourceInfoGroup dataSourceInfoGroup = dsg;
                    return dataSourceInfoGroup;
                }
                OperationContextCreator.getOrCreateForBos();
                ArrayList<Object> dss = new ArrayList<Object>(confs.size());
                for (DBConfig dbInfo : confs) {
                    boolean findShared;
                    block12: {
                        block11: {
                            findShared = false;
                            if (!CONSTANT.CONNECTION_SHARD || dbInfo.getDBType() != DBType.MySQL && dbInfo.getDBType() != DBType.TDSQL && dbInfo.getDBType() != DBType.TiDB && dbInfo.getDBType() != DBType.PostgreSQL) break block11;
                            DataSourceInfo shardDataSourceInfo = DataSourceCreateService.findSharedDataSourceInfo(dbInfo);
                            if (shardDataSourceInfo == null) break block12;
                            dss.add(shardDataSourceInfo);
                            shardDataSourceInfo.increaseSharingCount();
                            findShared = true;
                            break block12;
                        }
                        for (DataSourceInfoGroup dsi : routeGroupMap.values()) {
                            DataSourceInfo ds = dsi.findForSharing(dbInfo);
                            if (ds == null) continue;
                            dss.add(ds);
                            ds.increaseSharingCount();
                            findShared = true;
                            break;
                        }
                    }
                    if (findShared) continue;
                    try {
                        dss.add(DataSourceInfoCreator.createDataSource(dbInfo, defaultProps, dataSourceType));
                    }
                    catch (Exception e) {
                        String msg = "tenantId=" + tenantId + ", accountId=" + accountId + ", routeKey=" + routeKey + ", sharingId=" + dbInfo.getSharingId() + ", url=" + dbInfo.getUrl();
                        KDException kDException = new KDException((Throwable)e, BosErrorCode.dataSource, new Object[]{msg});
                        final_routeLockObject.w.unlock();
                        return kDException;
                    }
                }
                DataSourceInfoGroup ret = new DataSourceInfoGroup(accountKey + '#' + routeKey, dss.toArray(new DataSourceInfo[dss.size()]));
                ret.init();
                routeGroupMap.put(routeKey, ret);
                DataSourceCreateService.changeDBConfig(ret, tenantId, accountId, routeKey);
                DataSourceInfoGroup dataSourceInfoGroup = ret;
                return dataSourceInfoGroup;
            }
            finally {
                final_routeLockObject.w.unlock();
            }
        });
        try {
            Object ret = f.get(ts_timeout, TimeUnit.SECONDS);
            if (ret instanceof DataSourceInfoGroup) {
                return (DataSourceInfoGroup)ret;
            }
            if (ret instanceof Exception) {
                string = "Create datasource failed: " + ((Exception)ret).getMessage();
                throw new KDException((Throwable)((Exception)ret), BosErrorCode.dataSource, new Object[]{string});
            }
            string = Resources.get((String)"bos-dbengine", (String)"DataSourceCreateService_1", (String)"\u6570\u636e\u4e2d\u5fc3\u672a\u914d\u7f6e\u6570\u636e\u6e90: tenantId=", (Object[])new Object[0]) + tenantId + ", accountId=" + accountId + ", routeKey=" + routeKey;
            throw new Exception(string);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(Resources.get((String)"bos-dbengine", (String)"DataSourceCreateService_2", (String)"\u8fde\u63a5\u6c60\u521b\u5efa\u8d85\u65f6(>", (Object[])new Object[0]) + ts_timeout + "s): tenantId=" + tenantId + ", accountId=" + accountId + ", routeKey=" + routeKey, e);
        }
        catch (Exception e) {
            void var21_37;
            Exception exception = e;
            if (!(e instanceof ExecutionException)) throw ExceptionUtil.asRuntimeException((Throwable)var21_37);
            Throwable throwable = ((ExecutionException)e).getCause();
            throw ExceptionUtil.asRuntimeException((Throwable)var21_37);
        }
    }

    private static DataSourceInfo findSharedDataSourceInfo(DBConfig config) {
        for (Map.Entry<String, AccountDataSourceGroup> next : accountGroupMap.entrySet()) {
            AccountDataSourceGroup dataSourceGroup = next.getValue();
            Map routeGroupMap = dataSourceGroup.routeGroupMap;
            Collection groups = routeGroupMap.values();
            for (DataSourceInfoGroup dataSourceInfoGroup : groups) {
                DataSourceInfo sharingDataSource = dataSourceInfoGroup.findSharedDataSource(config);
                if (sharingDataSource == null) continue;
                return sharingDataSource;
            }
        }
        return null;
    }

    private static void changeDBConfig(DataSourceInfoGroup dsg, String tenantId, String accountId, String routeKey) {
        List<DBConfig> dbConfigs;
        DataSourceInfo dataSourceInfo;
        DBConfig dbConfig;
        if (CONSTANT.CONNECTION_SHARD && ((dbConfig = (dataSourceInfo = dsg.serve(false)).getDBConfig()).getDBType() == DBType.MySQL || dbConfig.getDBType() == DBType.TDSQL || dbConfig.getDBType() == DBType.TiDB || DBType.PostgreSQL == dbConfig.getDBType()) && (dbConfigs = DBExtensionsRegister.getDBConfigs(tenantId, routeKey, accountId, true)).size() > 0) {
            dataSourceInfo.setDBConfig(dbConfigs.get(0));
        }
    }

    static {
        ConfigurationUtil.observeInteger((String)"db.datasource.create.timeout", (int)300, v -> {
            ts_timeout = v;
        });
    }

    private static class RouteLockObject {
        private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        private final Lock r = this.rwl.readLock();
        private final Lock w = this.rwl.writeLock();

        private RouteLockObject() {
        }
    }

    private static class AccountDataSourceGroup {
        private final Map<String, DataSourceInfoGroup> routeGroupMap = new ConcurrentHashMap<String, DataSourceInfoGroup>();
        private final Map<String, RouteLockObject> routeLockObjectMap = new ConcurrentHashMap<String, RouteLockObject>();

        private AccountDataSourceGroup() {
        }
    }
}

