/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.OperationContextCreator;
import kd.bos.db.DBRoute;
import kd.bos.db.datasource.DataSourceType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.JSONUtils;

class DataSourcePropertyManager {
    private final boolean configWithDBRouteKey;
    private final Map<String, Properties> resultCache = new ConcurrentHashMap<String, Properties>();
    private final Properties defaultProperty = new Properties();
    private DataSourceType dataSourceType;

    DataSourcePropertyManager() {
        this(System.getProperty("datasource.config"));
    }

    DataSourcePropertyManager(String text) {
        if (text == null || "".equals(text.trim())) {
            this.dataSourceType = DataSourceType.hikari;
            this.configWithDBRouteKey = false;
            return;
        }
        List<DataSourceProperty> config = new DataSourcePropertyParser(text).parser();
        if (config == null) {
            this.configWithDBRouteKey = false;
            this.initWithKVProperty(text);
        } else {
            this.configWithDBRouteKey = true;
            this.initWithJsonProperty(config);
        }
    }

    private void initWithKVProperty(String text) {
        try {
            this.defaultProperty.load(new StringReader(text));
            this.dataSourceType = DataSourceType.from(this.defaultProperty.getProperty("datasource.type", DataSourceType.hikari.name()));
            if (this.dataSourceType == DataSourceType.hikari) {
                this.defaultProperty.remove("datasource.type");
            }
        }
        catch (IOException e) {
            OperationContextCreator.getOrCreateForBos();
            throw new KDException(BosErrorCode.dataSource, "Load data source kv config fail,msg:" + e.getMessage(), (Throwable)e);
        }
    }

    private void initWithJsonProperty(List<DataSourceProperty> propertyConfig) {
        Map<String, DataSourceConfig> dsConfig = DataSourceConfigFactory.create(propertyConfig);
        if (dsConfig.get("*#*") == null) {
            throw new KDException(BosErrorCode.dataSource, new Object[]{"DataSource use json config but not root config."});
        }
        for (DataSourceConfig dsc : dsConfig.values()) {
            String key = dsc.getAccountId() + '#' + dsc.getRouteKey();
            Properties prop = new Properties();
            dsc.getProp().forEach((k, v) -> {
                if ("datasource.type".equals(k) && v.equals(DataSourceType.hikari.name())) {
                    return;
                }
                prop.setProperty((String)k, (String)v);
            });
            if ("*#*".equals(dsc.getId())) {
                this.dataSourceType = DataSourceType.from((String)dsc.prop.get("datasource.type"));
                dsc.getProp().forEach((k, v) -> {
                    if ("datasource.type".equals(k) && v.equals(DataSourceType.hikari.name())) {
                        return;
                    }
                    this.defaultProperty.setProperty((String)k, (String)v);
                });
            }
            this.resultCache.put(key, prop);
        }
    }

    Properties getProperty(String accountId, String routeKey) {
        if (!this.configWithDBRouteKey) {
            return this.defaultProperty;
        }
        boolean needCache = false;
        Properties prop = this.getPropertyImmediate(accountId, routeKey);
        if (prop == null) {
            needCache = true;
            prop = this.resultCache.get(accountId + "#*");
        }
        if (prop == null) {
            prop = this.getPropertyImmediate("*", routeKey);
        }
        if (prop == null) {
            prop = this.defaultProperty;
        }
        if (needCache) {
            this.resultCache.put(accountId + '#' + routeKey, prop);
        }
        return prop;
    }

    Properties getDefaultProperty() {
        return this.defaultProperty;
    }

    private Properties getPropertyImmediate(String accountId, String routeKey) {
        DBRoute route = DBRoute.of(routeKey);
        Properties prop = this.resultCache.get(accountId + '#' + routeKey);
        while (!route.isRoot() && prop == null && (route = route.parent()) != null) {
            prop = this.resultCache.get(accountId + '#' + route.getRouteKey());
        }
        return prop;
    }

    DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    private static class DataSourceProperty {
        private String routeKeys;
        private String accountIds;
        private final Map<String, String> prop;

        public DataSourceProperty(String routeKeys, String accountIds, Map<String, String> prop) {
            this.routeKeys = routeKeys;
            this.accountIds = accountIds;
            if (this.routeKeys == null || "".equals(this.routeKeys.trim())) {
                this.routeKeys = "*";
            }
            if (this.accountIds == null || "".equals(this.accountIds.trim())) {
                this.accountIds = "*";
            }
            this.prop = prop;
        }

        public String getRouteKeys() {
            return this.routeKeys;
        }

        public String getAccountIds() {
            return this.accountIds;
        }

        public Map<String, String> getProp() {
            return this.prop;
        }
    }

    private static class DataSourcePropertyParser {
        private final String text;

        DataSourcePropertyParser(String text) {
            this.text = text;
        }

        List<DataSourceProperty> parser() {
            try {
                List configList = (List)JSONUtils.cast((String)this.text, ArrayList.class, (Class[])new Class[]{HashMap.class});
                ArrayList<DataSourceProperty> result = new ArrayList<DataSourceProperty>(configList.size());
                for (Map config : configList) {
                    result.add(this.createDataSourceProperty(config));
                }
                return result;
            }
            catch (Exception e) {
                return null;
            }
        }

        private DataSourceProperty createDataSourceProperty(Map<String, Object> config) {
            HashMap<String, String> prop = new HashMap<String, String>(config.size());
            config.forEach((k, v) -> prop.put((String)k, this.getStringValue(v, "")));
            String routeKeys = this.getStringValue(config.get("routeKeys"), "*");
            String accountIds = this.getStringValue(config.get("accountIds"), "*");
            return new DataSourceProperty(routeKeys, accountIds, prop);
        }

        private String getStringValue(Object val, String def) {
            if (val == null) {
                return def;
            }
            String result = val instanceof String ? (String)val : String.valueOf(val);
            if ("".equals(result.trim())) {
                return def;
            }
            return result;
        }
    }

    private static class DataSourceConfig {
        private final String routeKey;
        private final String accountId;
        private final Map<String, String> prop;
        private static final String SPLIT = ",";
        private static final String DEFAULT = "*";
        private static final String ROOT_ID = "*#*";

        public DataSourceConfig(String routeKey, String accountId, Map<String, String> prop) {
            this.routeKey = routeKey;
            this.accountId = accountId;
            this.prop = prop;
            this.prop.remove("routeKeys");
            this.prop.remove("accountIds");
        }

        public String getId() {
            return this.routeKey + '#' + this.accountId;
        }

        public String getRouteKey() {
            return this.routeKey;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public Map<String, String> getProp() {
            return new HashMap<String, String>(this.prop);
        }
    }

    private static class DataSourceConfigFactory {
        private DataSourceConfigFactory() {
        }

        static Map<String, DataSourceConfig> create(List<DataSourceProperty> dspList) {
            Map<String, DataSourceConfig> distinctDsp = DataSourceConfigFactory.distinct(dspList);
            return DataSourceConfigFactory.inherit(distinctDsp);
        }

        private static Map<String, DataSourceConfig> distinct(List<DataSourceProperty> dspList) {
            HashMap<String, DataSourceConfig> distinctDsp = new HashMap<String, DataSourceConfig>();
            for (DataSourceProperty dsp : dspList) {
                String[] accountIds;
                for (String accountId : accountIds = dsp.getAccountIds().split(",")) {
                    String[] routeKeys;
                    for (String routeKey : routeKeys = dsp.getRouteKeys().split(",")) {
                        DataSourceConfig dsc = new DataSourceConfig(routeKey, accountId, dsp.getProp());
                        distinctDsp.put(dsc.getId(), dsc);
                    }
                }
            }
            return distinctDsp;
        }

        private static Map<String, DataSourceConfig> inherit(Map<String, DataSourceConfig> distinctDsp) {
            DataSourceConfig root = distinctDsp.get("*#*");
            root.prop.computeIfAbsent("datasource.type", k -> DataSourceType.hikari.name());
            HashMap<String, DataSourceConfig> result = new HashMap<String, DataSourceConfig>();
            for (DataSourceConfig dsp : distinctDsp.values()) {
                if ("*".equals(dsp.getAccountId()) || "*".equals(dsp.getRouteKey())) {
                    HashMap<Object, Object> prop = new HashMap();
                    if (!"*".equals(dsp.getAccountId()) || !"*".equals(dsp.getRouteKey())) {
                        prop = new HashMap<String, String>(root.getProp());
                    }
                    dsp.getProp().remove("datasource.type");
                    prop.putAll(dsp.getProp());
                    DataSourceConfig r = new DataSourceConfig(dsp.getRouteKey(), dsp.getAccountId(), prop);
                    result.put(r.getId(), r);
                    continue;
                }
                DataSourceConfig accountDefault = distinctDsp.get(dsp.getRouteKey() + "#*");
                DataSourceConfig routeKeyDefault = distinctDsp.get("*#" + dsp.getRouteKey());
                HashMap<String, String> prop = new HashMap<String, String>(root.getProp());
                if (accountDefault != null) {
                    prop.putAll(accountDefault.getProp());
                }
                if (routeKeyDefault != null) {
                    prop.putAll(routeKeyDefault.getProp());
                }
                dsp.getProp().remove("datasource.type");
                prop.putAll(dsp.getProp());
                DataSourceConfig r = new DataSourceConfig(dsp.getRouteKey(), dsp.getAccountId(), prop);
                result.put(r.getId(), r);
            }
            return result;
        }
    }
}

