/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kd.bos.bundle.Resources;
import kd.bos.db.DBType;
import kd.bos.util.StringUtils;

public class DataSourceURLs {
    private static boolean useMysqlDbDriver;
    private static String TIDB_JDBC_DRIVER_VERSION;
    private static final boolean allowLoadLocalInfile;
    public static final String dmClusterServerName;
    private static final String MYSQL_URL_APPEND;
    private static final String PG_URL_APPEND;
    private static final String ORACLE_URL_APPEND;
    private static final String SQLSERVER_URL_APPEND;
    private static final String DM_URL_APPEND;
    private static final boolean dmUsePrepareOptimize;
    private static final boolean dmUseLog;
    private static final String dmLogDir;
    private static final String dmLogLever;
    public static final boolean sqlServerUnusedTLS;
    private static final Set<String> MYSQL_APPEND_WHITE_LIST;
    private static final Set<String> PG_APPEND_WHITE_LIST;
    private static final Set<String> ORACLE_APPEND_WHITE_LIST;
    private static final Set<String> SQLSERVER_APPEND_WHITE_LIST;
    private static final Set<String> DM_APPEND_WHITE_LIST;
    private static final String DM_CLUSTER_URL_APPEND;
    private static final String PG_CLUSTER_URL_APPEND;
    private static final String GAUSSDB_CLUSTER_URL_APPEND;
    private static final Set<String> DM_CLUSTER_APPEND_WHITE_LIST;
    private static final Set<String> PG_CLUSTER_APPEND_WHITE_LIST;
    private static final Set<String> GAUSSDB_CLUSTER_APPEND_WHITE_LIST;
    private static boolean pgUseCursorFetch;

    public static boolean isPgUseCursorFetch() {
        return pgUseCursorFetch;
    }

    public static boolean isUseMariaDbDriver() {
        return !useMysqlDbDriver;
    }

    public static String getTiDBJDBCDriverVersion() {
        return TIDB_JDBC_DRIVER_VERSION;
    }

    public static boolean isTiDBUseDriver5() {
        return "5".equals(DataSourceURLs.getTiDBJDBCDriverVersion());
    }

    public static boolean isAllowLoadLocalInfile() {
        return allowLoadLocalInfile;
    }

    public static String genURL(DBType dbType, String ip, int port, String db) {
        String url = DataSourceURLs.genURL0(dbType, ip, port, db, false, null);
        url = DataSourceURLs.appendURL(url, DataSourceURLs.getAppendURL(dbType));
        url = DataSourceURLs.appendURL(url, DataSourceURLs.getDefaultAppendURL(dbType));
        return url;
    }

    private static String genURL0(DBType dbType, String ip, int port, String db, boolean isCluster, String dbUrl) {
        switch (dbType) {
            case Oracle: {
                if (isCluster) {
                    String[] allIpPort;
                    StringBuilder sb = new StringBuilder();
                    sb.append("jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle10:jdbc:oracle:thin:@(DESCRIPTION=(ENABLE=BROKEN)(LOAD_BALANCE=on)(FAILOVER=on)(ADDRESS_LIST=");
                    for (String singleIpPort : allIpPort = dbUrl.split(",")) {
                        String[] ipPort = singleIpPort.split(":");
                        sb.append("(ADDRESS=(PROTOCOL=tcp)(HOST=");
                        sb.append(ipPort[0]);
                        sb.append(")(PORT=");
                        sb.append(ipPort[1]);
                        sb.append("))");
                    }
                    sb.append(")(CONNECT_DATA=(SERVICE_NAME=");
                    sb.append(db);
                    sb.append(")))");
                    return sb.toString();
                }
                return "jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle10:jdbc:oracle:thin:@" + ip + ":" + port + "/" + db;
            }
            case MySQL: {
                String url = DataSourceURLs.isUseMariaDbDriver() ? "jdbc:ksql:org.mariadb.jdbc.Driver:dbtype=mysql:jdbc:mariadb://" + ip + ":" + port + "/" + db : (isCluster ? "jdbc:ksql:com.mysql.cj.jdbc.Driver:dbtype=mysql:jdbc:mysql://" + dbUrl + "/" + db : "jdbc:ksql:com.mysql.cj.jdbc.Driver:dbtype=mysql:jdbc:mysql://" + ip + ":" + port + "/" + db);
                return url;
            }
            case Gbase: {
                if (isCluster) {
                    return "jdbc:ksql:org.gbase.Driver:dbtype=gbase:jdbc:gbase://" + dbUrl + "/" + db;
                }
                return "jdbc:ksql:org.gbase.Driver:dbtype=gbase:jdbc:gbase://" + ip + ":" + port + "/" + db;
            }
            case PostgreSQL: {
                if (isCluster) {
                    return "jdbc:ksql:org.postgresql.Driver:dbtype=postgresql:jdbc:postgresql://" + dbUrl + "/" + db;
                }
                return "jdbc:ksql:org.postgresql.Driver:dbtype=postgresql:jdbc:postgresql://" + ip + ":" + port + "/" + db;
            }
            case GS: {
                return "jdbc:ksql:org.postgresql.Driver:dbtype=gs:jdbc:postgresql://" + ip + ":" + port + "/" + db;
            }
            case GS100: {
                return "jdbc:ksql:com.huawei.gauss.jdbc.ZenithDriver:dbtype=gs100:jdbc:zenith:@" + ip + ":" + port;
            }
            case GaussDB: {
                if (isCluster) {
                    return "jdbc:ksql:com.huawei.opengauss.jdbc.Driver:dbtype=gaussdb:jdbc:opengauss://" + dbUrl + "/" + db;
                }
                return "jdbc:ksql:com.huawei.opengauss.jdbc.Driver:dbtype=gaussdb:jdbc:opengauss://" + ip + ":" + port + "/" + db;
            }
            case Gauss200: {
                if (isCluster) {
                    return "jdbc:ksql:com.huawei.gauss200.jdbc.Driver:dbtype=gauss200:jdbc:gaussdb://" + dbUrl + "/" + db;
                }
                return "jdbc:ksql:com.huawei.gauss200.jdbc.Driver:dbtype=gauss200:jdbc:gaussdb://" + ip + ":" + port + "/" + db;
            }
            case DM: {
                if (isCluster) {
                    return "jdbc:ksql:dm.jdbc.driver.DmDriver:dbtype=dm:jdbc:dm://" + dmClusterServerName + "?" + dmClusterServerName + "=(" + dbUrl + ")";
                }
                return "jdbc:ksql:dm.jdbc.driver.DmDriver:dbtype=dm:jdbc:dm://" + ip + ":" + port + "/" + db + "?schema=" + db + "&compatibleMode=oracle";
            }
            case SQLServer: {
                return "jdbc:ksql:com.microsoft.sqlserver.jdbc.SQLServerDriver:dbtype=sqlserver:jdbc:sqlserver://" + ip + ":" + port + ";DatabaseName=" + db + (sqlServerUnusedTLS ? ";encrypt=false;trustServerCertificate=true" : "");
            }
            case KingBase: {
                return "jdbc:ksql:com.kingbase8.Driver:dbtype=kingbase:jdbc:kingbase8://" + ip + ":" + port + "/" + db;
            }
            case Vastbase: {
                return "jdbc:ksql:cn.com.vastbase.Driver:dbtype=vastbase:jdbc:vastbase://" + ip + ":" + port + "/" + db;
            }
            case TDSQL: {
                if (isCluster) {
                    return "jdbc:ksql:com.tencentcloud.tdsql.mysql.cj.jdbc.Driver:dbtype=tdsql:jdbc:tdsql-mysql:loadbalance://" + dbUrl + "/" + db;
                }
                return "jdbc:ksql:com.tencentcloud.tdsql.mysql.cj.jdbc.Driver:dbtype=tdsql:jdbc:tdsql-mysql://" + ip + ":" + port + "/" + db;
            }
            case TiDB: {
                if (DataSourceURLs.isTiDBUseDriver5()) {
                    return "jdbc:ksql:com.kingdee.tidb.mysql.jdbc.Driver:dbtype=tidb:jdbc:tidb-mysql://" + ip + ":" + port + "/" + db;
                }
                return "jdbc:ksql:com.mysql.cj.jdbc.Driver:dbtype=tidb:jdbc:mysql://" + ip + ":" + port + "/" + db;
            }
            case YasDB: {
                if (isCluster) {
                    return "jdbc:ksql:com.yashandb.jdbc.Driver:dbtype=yasdb:jdbc:yasdb://" + dbUrl + "/" + db;
                }
                return "jdbc:ksql:com.yashandb.jdbc.Driver:dbtype=yasdb:jdbc:yasdb://" + ip + ":" + port + "/" + db;
            }
            case OceanBase_Oracle: {
                if (isCluster) {
                    return "jdbc:ksql:com.oceanbase.jdbc.Driver:dbtype=oceanbase_oracle:jdbc:oceanbase://" + dbUrl + "/" + db;
                }
                return "jdbc:ksql:com.oceanbase.jdbc.Driver:dbtype=oceanbase_oracle:jdbc:oceanbase://" + ip + ":" + port + "/" + db;
            }
            case HANA: {
                return "jdbc:ksql:com.sap.db.jdbc.Driver:dbtype=hana:jdbc:sap://" + ip + ":" + port + "/?databaseName=" + db;
            }
            case Greenplum: {
                if (isCluster) {
                    return "jdbc:ksql:com.pivotal.jdbc.GreenplumDriver:dbtype=greenplum:jdbc:pivotal:greenplum://" + dbUrl + ";;DatabaseName=" + db;
                }
                return "jdbc:ksql:com.pivotal.jdbc.GreenplumDriver:dbtype=greenplum:jdbc:pivotal:greenplum://" + ip + ":" + port + ";;DatabaseName=" + db;
            }
            case ClickHouse: {
                return "jdbc:ksql:com.clickhouse.jdbc.ClickHouseDriver:dbtype=clickhouse:jdbc:clickhouse://" + ip + ":" + port + "/" + db;
            }
        }
        String msg = Resources.get((String)"bos-dbengine", (String)"DataSourceURLs_0", (String)"[\u6570\u636e\u4e2d\u5fc3\u5b9e\u4f8b]\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a", (Object[])new Object[0]) + (Object)((Object)dbType) + ", ip=" + ip + ", port=" + port + ", db=" + db;
        throw new RuntimeException(msg);
    }

    public static String appendURL(String url, Map<String, String> appendMap) {
        int p = url.indexOf(63);
        Map<Object, Object> existsMap = p != -1 ? DataSourceURLs.toMap(url.substring(p + 1)) : new HashMap();
        StringBuilder sb = new StringBuilder(url);
        int link = p == -1 ? 63 : 38;
        for (Map.Entry<String, String> entry : appendMap.entrySet()) {
            String key = entry.getKey();
            if (existsMap.containsKey(key)) continue;
            sb.append((char)link).append(key).append('=').append(entry.getValue());
            link = 38;
        }
        return sb.toString();
    }

    public static String genURL(DBType dbType, String ip, int port, String db, String schema) {
        String url = DataSourceURLs.genURL(dbType, ip, port, db);
        url = DataSourceURLs.appendURL(url, DataSourceURLs.getAppendURL(dbType));
        HashMap<String, String> append = new HashMap<String, String>(8);
        if (DBType.Greenplum == dbType) {
            url = url + ";initializationString=set search_path to " + schema;
        } else {
            append.put("currentSchema", schema);
        }
        url = DataSourceURLs.appendURL(url, append);
        return url;
    }

    public static String appendURL(String url, String appendURL) {
        return DataSourceURLs.appendURL(url, DataSourceURLs.toMap(appendURL));
    }

    private static Map<String, String> toMap(String appendURL) {
        String[] ps;
        if (appendURL.startsWith("&") || appendURL.startsWith("?")) {
            appendURL = appendURL.substring(1);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String s : ps = appendURL.split("&")) {
            int eq = s.indexOf(61);
            if (eq == -1 || eq == s.length() - 1) continue;
            map.put(s.substring(0, eq), s.substring(eq + 1));
        }
        return map;
    }

    public static Map<String, String> getDefaultAppendURL(DBType dbType) {
        if (dbType == DBType.MySQL) {
            return DataSourceURLs.toMap(DataSourceURLs.getDefaultMySqlAppendURL());
        }
        if (dbType == DBType.DM) {
            return DataSourceURLs.toMap(DataSourceURLs.getDefaultDMSqlAppendURL());
        }
        if ((dbType == DBType.PostgreSQL || dbType == DBType.KingBase || dbType == DBType.GaussDB || dbType == DBType.Vastbase) && pgUseCursorFetch) {
            return DataSourceURLs.toMap(DataSourceURLs.getDefaultPostgreSqlAppendURL());
        }
        if (dbType == DBType.TDSQL) {
            return DataSourceURLs.toMap(DataSourceURLs.getDefaultTDSqlAppendURL());
        }
        if (dbType == DBType.TiDB) {
            return DataSourceURLs.toMap(DataSourceURLs.getDefaultTiDBAppendURL());
        }
        if (dbType == DBType.Gbase) {
            return DataSourceURLs.toMap(DataSourceURLs.getDefaultGbaseppendURL());
        }
        if (dbType == DBType.OceanBase_Oracle) {
            return DataSourceURLs.toMap(DataSourceURLs.getDefaultOBSqlAppendURL());
        }
        if (dbType == DBType.ClickHouse) {
            return DataSourceURLs.toMap(DataSourceURLs.getDefaultClickHouseAppendURL());
        }
        return new HashMap<String, String>();
    }

    public static Map<String, String> getAppendURL(DBType dbType) {
        if (dbType == DBType.MySQL) {
            return DataSourceURLs.getAppendURL0(MYSQL_URL_APPEND, MYSQL_APPEND_WHITE_LIST);
        }
        if (dbType == DBType.PostgreSQL) {
            return DataSourceURLs.getAppendURL0(PG_URL_APPEND, PG_APPEND_WHITE_LIST);
        }
        if (dbType == DBType.Oracle) {
            return DataSourceURLs.getAppendURL0(ORACLE_URL_APPEND, ORACLE_APPEND_WHITE_LIST);
        }
        if (dbType == DBType.SQLServer) {
            return DataSourceURLs.getAppendURL0(SQLSERVER_URL_APPEND, SQLSERVER_APPEND_WHITE_LIST);
        }
        if (dbType == DBType.DM) {
            return DataSourceURLs.getAppendURL0(DM_URL_APPEND, DM_APPEND_WHITE_LIST);
        }
        return new HashMap<String, String>();
    }

    public static Map<String, String> getClusterAppendURL(DBType dbType) {
        if (dbType == DBType.DM) {
            return DataSourceURLs.getAppendURL0(DM_CLUSTER_URL_APPEND, DM_CLUSTER_APPEND_WHITE_LIST);
        }
        if (dbType == DBType.PostgreSQL) {
            return DataSourceURLs.getAppendURL0(PG_CLUSTER_URL_APPEND, PG_CLUSTER_APPEND_WHITE_LIST);
        }
        if (dbType == DBType.GaussDB) {
            return DataSourceURLs.getAppendURL0(GAUSSDB_CLUSTER_URL_APPEND, GAUSSDB_CLUSTER_APPEND_WHITE_LIST);
        }
        return new HashMap<String, String>();
    }

    private static Map<String, String> getAppendURL0(String url, Set<String> whiteList) {
        Map<String, String> map = DataSourceURLs.toMap(url);
        HashMap<String, String> allow = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!whiteList.contains(entry.getKey())) continue;
            allow.put(entry.getKey(), entry.getValue());
        }
        return allow;
    }

    public static String getDefaultMySqlAppendURL() {
        String serverTimezone = System.getProperty("mysql.serverTimezone", "Asia/Shanghai");
        String common = "serverTimezone=" + serverTimezone + "&zeroDateTimeBehavior=round&useUnicode=true&characterEncoding=UTF-8&rewriteBatchedStatements=true";
        String fetch = "&allowMultiQueries=true&defaultFetchSize=1000&useCursorFetch=true&useServerPrepStmts=true&cachePrepStmts=false&prepStmtCacheSize=5&prepStmtCacheSqlLimit=4096";
        String batch = "&useServerPrepStmts=false&useCompression=true";
        String allowLoadLocalInfileUrl = "&allowLoadLocalInfile=true";
        if (!allowLoadLocalInfile) {
            allowLoadLocalInfileUrl = "&allowLoadLocalInfile=false";
        }
        return common + allowLoadLocalInfileUrl + "&allowMultiQueries=true&defaultFetchSize=1000&useCursorFetch=true&useServerPrepStmts=true&cachePrepStmts=false&prepStmtCacheSize=5&prepStmtCacheSqlLimit=4096";
    }

    public static String getDefaultTDSqlAppendURL() {
        return "allowMultiQueries=true&allowLoadLocalInfile=true";
    }

    public static String getDefaultTiDBAppendURL() {
        String common = "zeroDateTimeBehavior=round";
        String allowLoadLocalInfileUrl = "&allowLoadLocalInfile=true";
        if (!allowLoadLocalInfile) {
            allowLoadLocalInfileUrl = "&allowLoadLocalInfile=false";
        }
        String fetch = "&allowMultiQueries=true&rewriteBatchedStatements=true&useServerPrepStmts=true";
        return "zeroDateTimeBehavior=round" + allowLoadLocalInfileUrl + "&allowMultiQueries=true&rewriteBatchedStatements=true&useServerPrepStmts=true";
    }

    public static String getDefaultGbaseppendURL() {
        return "batchMode=off&useCursorFetch=true&defaultRowFetchSize=5000";
    }

    public static String getDefaultDMSqlAppendURL() {
        StringBuilder ret = new StringBuilder();
        if (dmUsePrepareOptimize) {
            ret.append("prepareOptimize=true");
        }
        if (dmUseLog && StringUtils.isNotEmpty((String)dmLogDir)) {
            ret.append("&logLevel=").append(dmLogLever).append("&logDir=").append(dmLogDir);
        }
        return ret.toString();
    }

    public static String getDefaultPostgreSqlAppendURL() {
        return "useCursorFetch=true&defaultRowFetchSize=5000";
    }

    public static String getDefaultClickHouseAppendURL() {
        return "socket_timeout=600000";
    }

    public static String genClusterUrl(DBType dbType, String clusterDbUrl, String db, String schema) {
        String url = DataSourceURLs.genClusterUrl(dbType, clusterDbUrl, db);
        HashMap<String, String> append = new HashMap<String, String>(8);
        append.put("currentSchema", schema);
        url = DataSourceURLs.appendURL(url, append);
        if (dbType == DBType.MySQL) {
            url = DataSourceURLs.appendURL(url, DataSourceURLs.getDefaultAppendURL(dbType));
        }
        return url;
    }

    public static String genClusterUrl(DBType dbType, String clusterDbUrl, String db) {
        String url = DataSourceURLs.genURL0(dbType, null, -1, db, true, clusterDbUrl);
        url = DataSourceURLs.appendURL(url, DataSourceURLs.getClusterAppendURL(dbType));
        if (dbType == DBType.MySQL) {
            url = DataSourceURLs.appendURL(url, DataSourceURLs.getDefaultAppendURL(dbType));
        }
        return url;
    }

    public static String getDefaultOBSqlAppendURL() {
        return "pool=true&useBulkStmts=true&rewriteBatchedStatements=true&useServerPrepStmts=true&usePieceData=true&useCursorFetch=true&defaultFetchSize=1000";
    }

    static {
        String gsClusterWriteListKeys;
        String pgClusterWriteListKeys;
        useMysqlDbDriver = Boolean.parseBoolean(System.getProperty("datasource.mysql", "true"));
        TIDB_JDBC_DRIVER_VERSION = System.getProperty("db.tidb.jdbc_driver_version", "8");
        allowLoadLocalInfile = Boolean.parseBoolean(System.getProperty("db.mysql.url.allowLoadLocalInfile", "true"));
        dmClusterServerName = System.getProperty("db.dm.cluster.serverName", "dmrw");
        MYSQL_URL_APPEND = System.getProperty("db.mysql.url.append", "");
        PG_URL_APPEND = System.getProperty("db.pg.url.append", "");
        ORACLE_URL_APPEND = System.getProperty("db.oracle.url.append", "");
        SQLSERVER_URL_APPEND = System.getProperty("db.sqlserver.url.append", "");
        DM_URL_APPEND = System.getProperty("db.dm.url.append", "");
        dmUsePrepareOptimize = Boolean.parseBoolean(System.getProperty("db.dm.url.prepareOptimize", "false"));
        dmUseLog = Boolean.parseBoolean(System.getProperty("db.dm.url.useLog", "false"));
        dmLogDir = System.getProperty("db.dm.url.logDir", System.getProperty("java.io.tmpdir"));
        dmLogLever = System.getProperty("db.dm.url.logLevel", "all");
        sqlServerUnusedTLS = Boolean.parseBoolean(System.getProperty("db.sqlserver.url.unusedTLS", "true"));
        MYSQL_APPEND_WHITE_LIST = new CopyOnWriteArraySet<String>();
        PG_APPEND_WHITE_LIST = new CopyOnWriteArraySet<String>();
        ORACLE_APPEND_WHITE_LIST = new CopyOnWriteArraySet<String>();
        SQLSERVER_APPEND_WHITE_LIST = new CopyOnWriteArraySet<String>();
        DM_APPEND_WHITE_LIST = new CopyOnWriteArraySet<String>();
        DM_CLUSTER_URL_APPEND = System.getProperty("db.dm.cluster.url.append", "rwSeparate=0&rwPercent=0&login_mode=1");
        PG_CLUSTER_URL_APPEND = System.getProperty("db.pg.cluster.url.append", "targetServerType=primary");
        GAUSSDB_CLUSTER_URL_APPEND = System.getProperty("db.gaussdb.cluster.url.append", "targetServerType=master");
        DM_CLUSTER_APPEND_WHITE_LIST = new CopyOnWriteArraySet<String>();
        PG_CLUSTER_APPEND_WHITE_LIST = new CopyOnWriteArraySet<String>();
        GAUSSDB_CLUSTER_APPEND_WHITE_LIST = new CopyOnWriteArraySet<String>();
        pgUseCursorFetch = true;
        MYSQL_APPEND_WHITE_LIST.add("disableMariaDbDriver");
        MYSQL_APPEND_WHITE_LIST.add("rewriteBatchedStatements");
        String dmClusterWriteListKeys = System.getProperty("db.dm.cluster.url.writeListKeys", "rwSeparate,rwPercent,login_mode");
        if (dmClusterWriteListKeys.length() > 0) {
            DM_CLUSTER_APPEND_WHITE_LIST.addAll(Arrays.asList(dmClusterWriteListKeys.split(",")));
        }
        if ((pgClusterWriteListKeys = System.getProperty("db.pg.cluster.url.writeListKeys", "targetServerType")).length() > 0) {
            PG_CLUSTER_APPEND_WHITE_LIST.addAll(Arrays.asList(pgClusterWriteListKeys.split(",")));
        }
        if ((gsClusterWriteListKeys = System.getProperty("db.gaussdb.cluster.url.writeListKeys", "targetServerType")).length() > 0) {
            GAUSSDB_CLUSTER_APPEND_WHITE_LIST.addAll(Arrays.asList(gsClusterWriteListKeys.split(",")));
        }
    }
}

