/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceConfig;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.datasource.ReplicationDelayInfo;
import kd.bos.db.datasource.ReplicationDelayInfoChangeListener;
import kd.bos.db.datasource.ReplicationDelayInfoManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.serializer.HessianSerializer;

abstract class ReplicationDelayInfoManagerBase
implements ReplicationDelayInfoManager {
    private static final Log log = LogFactory.getLog(ReplicationDelayInfoManagerBase.class);
    private final DataSourceInfo master;
    private final DataSourceInfo slave;
    private final String cacheKey;
    private final List<ReplicationDelayInfoChangeListener> listeners = new CopyOnWriteArrayList<ReplicationDelayInfoChangeListener>();
    private volatile ReplicationDelayInfo delayInfo;

    public ReplicationDelayInfoManagerBase(DataSourceInfo master, DataSourceInfo slave) {
        this.master = master;
        this.slave = slave;
        this.cacheKey = Instance.getClusterName() + ":kd.bos.db.slaveDBReplicationDelayInfo:";
    }

    private String dataSourceString(DataSourceInfo dataSourceInfo) {
        DBConfig dbConfig = dataSourceInfo.getDBConfig();
        return dbConfig.getIp() + '_' + dbConfig.getPort();
    }

    protected DataSourceInfo getMaster() {
        return this.master;
    }

    protected DataSourceInfo getSlave() {
        return this.slave;
    }

    /*
     * Exception decompiling
     */
    protected <T> T executeQuery(Connection connection, String sql, ResultSetHandler<T> handler) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    abstract ReplicationDelayInfo doUpdateDelayInfo() throws Exception;

    @Override
    public void updateDelayInfo() {
        ReplicationDelayInfo old = this.delayInfo;
        try {
            ReplicationDelayInfo replicationDelayInfo = this.getFromCache();
            if (replicationDelayInfo == null) {
                this.delayInfo = this.doUpdateDelayInfo();
                this.cache(this.delayInfo);
            } else {
                this.delayInfo = replicationDelayInfo;
            }
        }
        catch (Exception exception) {
            log.warn("slave_db_delay: Cause an exception when update slave db replication delay info, " + exception.getMessage(), (Throwable)exception);
            this.delayInfo = null;
        }
        finally {
            if (!Objects.equals(old, this.delayInfo)) {
                this.fireDelayInfoChange(this.delayInfo);
            }
        }
    }

    private ReplicationDelayInfo getFromCache() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("db");
        byte[] data = cache.hget(this.cacheKey, this.getCacheDataField());
        byte[] expire = cache.hget(this.cacheKey, this.getCacheExpireField());
        if (expire == null) {
            return null;
        }
        Long expireAt = (Long)HessianSerializer.deserialize((byte[])expire);
        if (System.currentTimeMillis() / 1000L >= expireAt) {
            return null;
        }
        return (ReplicationDelayInfo)HessianSerializer.deserialize((byte[])data);
    }

    protected int getCacheExpireSecond() {
        return (int)TimeUnit.MINUTES.toSeconds(DataSourceConfig.getReplicationDelayInfoCacheExpireMinute());
    }

    private void cache(ReplicationDelayInfo replicationDelayInfo) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("db");
        int timeoutSeconds = this.getCacheExpireSecond();
        Long expireAt = System.currentTimeMillis() / 1000L + (long)timeoutSeconds;
        cache.hset(this.cacheKey, this.getCacheDataField(), HessianSerializer.serialize((Object)replicationDelayInfo), timeoutSeconds);
        cache.hset(this.cacheKey, this.getCacheExpireField(), HessianSerializer.serialize((Object)expireAt), timeoutSeconds);
    }

    private byte[] getCacheExpireField() {
        String fieldPrefix = this.master.getDBConfig().getDBType().name() + "@" + this.dataSourceString(this.master) + '_' + this.dataSourceString(this.slave);
        return (fieldPrefix + "_expireAt").getBytes(StandardCharsets.UTF_8);
    }

    private byte[] getCacheDataField() {
        String fieldPrefix = this.master.getDBConfig().getDBType().name() + "@" + this.dataSourceString(this.master) + '_' + this.dataSourceString(this.slave);
        return (fieldPrefix + "_data").getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public ReplicationDelayInfo getReplicationDelayInfo() {
        return this.delayInfo;
    }

    private void fireDelayInfoChange(ReplicationDelayInfo delayInfo) {
        for (ReplicationDelayInfoChangeListener listener : this.listeners) {
            try {
                listener.onChange(delayInfo);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void registerReplicationDelayInfoListener(ReplicationDelayInfoChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }
}

