/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.datasource.ReplicationDelayInfoManager;
import kd.bos.db.datasource.ReplicationDelayTaskScheduleService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class ReplicationDelayInfoUpdateTask
implements Runnable {
    private static final Log log = LogFactory.getLog(ReplicationDelayInfoUpdateTask.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ReplicationDelayInfoManager query;

    public ReplicationDelayInfoUpdateTask(ReplicationDelayInfoManager query) {
        this.query = query;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            ReplicationDelayTaskScheduleService.schedule(this, 0, TimeUnit.SECONDS);
        }
    }

    @Override
    public void run() {
        try {
            this.query.updateDelayInfo();
        }
        catch (Throwable exception) {
            log.warn("Replication delay info update task execute cause an exception: " + exception.getMessage(), exception);
        }
        finally {
            ReplicationDelayTaskScheduleService.schedule(this);
        }
    }
}

