/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.x.GetConnectionHandler;
import kd.bos.db.datasource.x.XDataSource;
import kd.bos.db.extension.DBExtensionsRegister;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RetryGetConnectionHandler
implements GetConnectionHandler {
    private static final Log log = LogFactory.getLog((String)"DB");
    private AtomicBoolean retrying = new AtomicBoolean(false);
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(DataSource ds, XDataSource xds) throws SQLException {
        while (true) {
            Object object;
            if (this.retrying.get()) {
                object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            try {
                object = ds.getConnection();
                return object;
            }
            catch (SQLException e) {
                log.warn("getConnection failed: " + e.getMessage(), (Throwable)e);
                String sqlState = null;
                for (SQLException cur = e; (sqlState = cur.getSQLState()) == null && cur != cur.getCause() && cur.getCause() != null && cur.getCause() instanceof SQLException; cur = (SQLException)cur.getCause()) {
                }
                if ("28000".equals(sqlState)) {
                    if (this.retrying.compareAndSet(false, true)) continue;
                    DBConfig oldConf = xds.getDBConfig();
                    log.warn("reloading dbconfig for: " + oldConf.getSharingId());
                    DBConfig newConf = null;
                    List<DBConfig> confs = DBExtensionsRegister.getDBConfigs(oldConf.getTenantId(), oldConf.getRouteKey(), oldConf.getAccountId(), false);
                    log.warn("all dbconfig=" + confs.size());
                    for (DBConfig conf : confs) {
                        if (oldConf.isReadOnly() != conf.isReadOnly() || !oldConf.canSharing(conf) || oldConf.getUrl().equals(conf.getUrl())) continue;
                        newConf = conf;
                        break;
                    }
                    if (newConf != null) {
                        log.warn("found and set new dbconfig:" + newConf.getUrl() + ", the old is " + oldConf.getUrl());
                        xds.setUrl(newConf.getUrl());
                        xds.setDBConfig(newConf);
                        continue;
                    }
                    throw e;
                }
                throw e;
            }
            finally {
                if (!this.retrying.compareAndSet(true, false)) continue;
                Object object2 = this.lock;
                synchronized (object2) {
                    this.lock.notifyAll();
                }
                continue;
            }
            break;
        }
    }
}

