/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource.x;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.sql.DataSource;
import kd.bos.db.datasource.x.XDataSource;
import kd.bos.db.datasource.x.XPoolStatus;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

class DBCPDataSource
extends XDataSource {
    private BasicDataSource ds;

    DBCPDataSource(BasicDataSource ds) {
        super((DataSource)ds);
        this.ds = ds;
    }

    @Override
    public String getUsername() {
        return this.ds.getUsername();
    }

    @Override
    public void setUsername(String username) {
        Properties ps = this.getDriverConnectionFactoryProperties();
        if (ps != null) {
            if (username == null) {
                ps.remove("user");
            } else {
                ps.put("user", username);
            }
        }
        this.ds.setUsername(username);
    }

    @Override
    public String getPassword() {
        return this.ds.getPassword();
    }

    @Override
    public void setPassword(String password) {
        Properties ps = this.getDriverConnectionFactoryProperties();
        if (ps != null) {
            if (password == null) {
                ps.remove("password");
            } else {
                ps.put("password", password);
            }
        }
        this.ds.setPassword(password);
    }

    @Override
    public void clearUsernameAndPassword() {
        this.setUsername(null);
        this.setPassword(null);
    }

    @Override
    public String getUrl() {
        return this.ds.getUrl();
    }

    @Override
    public void setUrl(String url) {
        try {
            DriverConnectionFactory dcf = this.getDriverConnectionFactory();
            if (dcf != null) {
                Field field = DriverConnectionFactory.class.getDeclaredField("_connectUri");
                field.setAccessible(true);
                field.set(dcf, url);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.ds.setUrl(url);
    }

    private Properties getDriverConnectionFactoryProperties() {
        try {
            DriverConnectionFactory dcf = this.getDriverConnectionFactory();
            if (dcf != null) {
                Field field = DriverConnectionFactory.class.getDeclaredField("_props");
                field.setAccessible(true);
                return (Properties)field.get(dcf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private DriverConnectionFactory getDriverConnectionFactory() throws Exception {
        GenericObjectPool<PoolableConnection> pool = this.getPool();
        if (pool != null) {
            PoolableConnectionFactory pcf = (PoolableConnectionFactory)pool.getFactory();
            Method getConnectionFactory = PoolableConnectionFactory.class.getDeclaredMethod("getConnectionFactory", new Class[0]);
            getConnectionFactory.setAccessible(true);
            return (DriverConnectionFactory)getConnectionFactory.invoke((Object)pcf, new Object[0]);
        }
        return null;
    }

    private GenericObjectPool<PoolableConnection> getPool() throws Exception {
        Method getConnectionPool = BasicDataSource.class.getDeclaredMethod("getConnectionPool", new Class[0]);
        getConnectionPool.setAccessible(true);
        return (GenericObjectPool)getConnectionPool.invoke((Object)this.ds, new Object[0]);
    }

    @Override
    public void close() throws Exception {
        if (!allowClose) {
            throw new IllegalAccessException("DataSource not allow close!");
        }
        this.ds.close();
    }

    @Override
    public XPoolStatus getPoolStatus() {
        try {
            GenericObjectPool<PoolableConnection> pool = this.getPool();
            if (pool == null) {
                return new XPoolStatus("pool is null");
            }
            XPoolStatus s = new XPoolStatus(this.ds.toString());
            s.setActive(pool.getNumActive());
            s.setIdle(pool.getNumIdle());
            s.setMaxTotal(pool.getMaxTotal());
            s.setMaxIdle(pool.getMaxIdle());
            s.setWaitCount(pool.getNumWaiters());
            s.setCreatedCount(pool.getCreatedCount());
            s.setDestroyedCount(pool.getDestroyedCount());
            s.setReturnedCount(pool.getReturnedCount());
            s.setBorrowedCount(pool.getBorrowedCount());
            return s;
        }
        catch (Exception e) {
            return new XPoolStatus("getPoolStatus error: " + e.getMessage());
        }
    }
}

