/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource.x;

import com.alibaba.druid.pool.DruidAbstractDataSource;
import java.lang.reflect.Field;
import javax.sql.DataSource;
import kd.bos.db.datasource.x.XDataSource;
import kd.bos.db.datasource.x.XPoolStatus;

class DruidDataSource
extends XDataSource {
    private static final long DEFAULT_MAX_WAIT = 5000L;
    private com.alibaba.druid.pool.DruidDataSource ds;

    DruidDataSource(com.alibaba.druid.pool.DruidDataSource ds) {
        super((DataSource)ds);
        if (ds.getMaxWait() <= 0L) {
            ds.setMaxWait(5000L);
        }
        if (ds.getNotFullTimeoutRetryCount() == 0) {
            ds.setNotFullTimeoutRetryCount(-1);
        }
        this.ds = ds;
    }

    @Override
    public String getUrl() {
        return this.ds.getUrl();
    }

    @Override
    public void setUrl(String url) {
        this.setField("jdbcUrl", url);
    }

    @Override
    public String getUsername() {
        return this.ds.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.setField("username", username);
    }

    @Override
    public String getPassword() {
        return this.ds.getPassword();
    }

    @Override
    public void setPassword(String password) {
        this.setField("password", password);
    }

    @Override
    public void clearUsernameAndPassword() {
        this.setUsername(null);
        this.setPassword(null);
    }

    private void setField(String name, String value) {
        try {
            Field field = DruidAbstractDataSource.class.getDeclaredField(name);
            field.setAccessible(true);
            field.set(this.ds, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        if (!allowClose) {
            throw new IllegalAccessException("DataSource not allow close!");
        }
        this.ds.close();
    }

    @Override
    public XPoolStatus getPoolStatus() {
        try {
            XPoolStatus s = new XPoolStatus(this.ds.toString());
            s.setActive(this.ds.getActiveCount());
            s.setIdle(this.ds.getPoolingCount() - this.ds.getActiveCount());
            s.setMaxTotal(this.ds.getMaxActive());
            s.setMaxIdle(this.ds.getMaxIdle());
            s.setWaitCount(this.ds.getWaitThreadCount());
            s.setCreatedCount(this.ds.getCreateCount());
            s.setDestroyedCount(this.ds.getDestroyCount());
            s.setReturnedCount(this.ds.getCloseCount());
            s.setBorrowedCount(this.ds.getConnectCount());
            return s;
        }
        catch (Exception e) {
            return new XPoolStatus("getPoolStatus error: " + e.getMessage());
        }
    }
}

