/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource.x;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import javax.sql.DataSource;
import kd.bos.db.datasource.x.XDataSource;
import kd.bos.db.datasource.x.XPoolStatus;

class XHikariDataSource
extends XDataSource {
    private HikariDataSource ds;

    XHikariDataSource(HikariDataSource ds) {
        super((DataSource)ds);
        this.ds = ds;
    }

    @Override
    public String getUsername() {
        return this.ds.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.ds.setUsername(username);
    }

    @Override
    public String getPassword() {
        return this.ds.getPassword();
    }

    @Override
    public void setPassword(String password) {
        this.ds.setPassword(password);
    }

    @Override
    public void clearUsernameAndPassword() {
        this.setUsername(null);
        this.setPassword(null);
    }

    @Override
    public String getUrl() {
        return this.ds.getJdbcUrl();
    }

    @Override
    public void setUrl(String url) {
        this.ds.setJdbcUrl(url);
    }

    @Override
    public void close() throws Exception {
        if (!allowClose) {
            throw new IllegalAccessException("DataSource not allow close!");
        }
        this.ds.close();
    }

    @Override
    public XPoolStatus getPoolStatus() {
        try {
            XPoolStatus s = new XPoolStatus(this.ds.toString());
            HikariPoolMXBean hb = this.ds.getHikariPoolMXBean();
            s.setActive(hb.getActiveConnections());
            s.setIdle(hb.getIdleConnections());
            s.setMaxTotal(hb.getTotalConnections());
            s.setMaxIdle(-1);
            s.setWaitCount(hb.getThreadsAwaitingConnection());
            s.setCreatedCount(-1L);
            s.setDestroyedCount(-1L);
            s.setReturnedCount(-1L);
            s.setBorrowedCount(-1L);
            return s;
        }
        catch (Exception e) {
            return new XPoolStatus("getPoolStatus error: " + e.getMessage());
        }
    }
}

