/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource.x;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.pktemptable.utils.DiscardUtil;
import kd.bos.xdb.util.DateUtil;

public class XPoolStatus {
    private String msg;
    private Integer active;
    private Integer idle;
    private Integer maxTotal;
    private Integer maxIdle;
    private Integer waitCount;
    private Long createdCount;
    private Long destroyedCount;
    private Long borrowedCount;
    private Long returnedCount;
    private final String createTime;
    private static final Map<String, Field> FIELD_MAP = new ConcurrentHashMap<String, Field>(16);

    public XPoolStatus(String msg) {
        this.msg = msg;
        this.createTime = DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
    }

    public void sum(String fieldName, XPoolStatus other) throws NoSuchFieldException, IllegalAccessException {
        Field field = FIELD_MAP.get(fieldName);
        if (field == null) {
            field = this.getClass().getDeclaredField(fieldName);
            FIELD_MAP.put(fieldName, field);
        }
        if (field.getType().equals(Integer.class)) {
            Integer val = (Integer)field.get(other);
            if (val == null || val < 0) {
                return;
            }
            Integer old = (Integer)field.get(this);
            if (old == null) {
                old = 0;
            }
            field.set(this, old + val);
        } else if (field.getType().equals(Long.class)) {
            Long val = (Long)field.get(other);
            if (val == null || val < 0L) {
                return;
            }
            Long old = (Long)field.get(this);
            if (old == null) {
                old = 0L;
            }
            field.set(this, old + val);
        } else if (field.getType().equals(String.class)) {
            String val = (String)field.get(other);
            if (val == null) {
                return;
            }
            String old = (String)field.get(this);
            if (old == null) {
                old = "";
            }
            field.set(this, old + val);
        } else {
            DiscardUtil.discard();
        }
    }

    public void addup(XPoolStatus xps) {
        try {
            this.sum("active", xps);
            this.sum("idle", xps);
            this.sum("maxTotal", xps);
            this.sum("maxIdle", xps);
            this.sum("waitCount", xps);
            this.sum("createdCount", xps);
            this.sum("destroyedCount", xps);
            this.sum("borrowedCount", xps);
            this.sum("returnedCount", xps);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            DiscardUtil.discard(e);
        }
    }

    void setActive(Integer active) {
        this.active = active;
    }

    void setIdle(Integer idle) {
        this.idle = idle;
    }

    void setMaxTotal(Integer maxTotal) {
        this.maxTotal = maxTotal;
    }

    void setMaxIdle(Integer maxIdle) {
        this.maxIdle = maxIdle;
    }

    void setWaitCount(Integer waitCount) {
        this.waitCount = waitCount;
    }

    void setCreatedCount(Long createdCount) {
        this.createdCount = createdCount;
    }

    void setDestroyedCount(Long destroyedCount) {
        this.destroyedCount = destroyedCount;
    }

    void setBorrowedCount(Long borrowedCount) {
        this.borrowedCount = borrowedCount;
    }

    void setReturnedCount(Long returnedCount) {
        this.returnedCount = returnedCount;
    }

    public Integer getActive() {
        return this.active;
    }

    public Integer getIdle() {
        return this.idle;
    }

    public Integer getMaxTotal() {
        return this.maxTotal;
    }

    public Integer getMaxIdle() {
        return this.maxIdle;
    }

    public Long getCreatedCount() {
        return this.createdCount;
    }

    public Long getDestroyedCount() {
        return this.destroyedCount;
    }

    public Long getBorrowedCount() {
        return this.borrowedCount;
    }

    public Long getReturnedCount() {
        return this.returnedCount;
    }

    public Integer getWaitCount() {
        return this.waitCount;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.msg).append(" POOL{");
        if (this.active != null && this.active >= 0) {
            sb.append("active:").append(this.active);
        }
        if (this.idle != null && this.idle >= 0) {
            sb.append(",idle:").append(this.idle);
        }
        if (this.maxTotal != null && this.maxTotal >= 0) {
            sb.append(",maxTotal:").append(this.maxTotal);
        }
        if (this.maxIdle != null && this.maxIdle >= 0) {
            sb.append(",maxIdle:").append(this.maxIdle);
        }
        if (this.waitCount != null && this.waitCount >= 0) {
            sb.append(",waitCount:").append(this.waitCount);
        }
        if (this.createdCount != null && this.createdCount >= 0L) {
            sb.append(",createdCount:").append(this.createdCount);
        }
        if (this.destroyedCount != null && this.destroyedCount >= 0L) {
            sb.append(",destroyedCount:").append(this.destroyedCount);
        }
        if (this.borrowedCount != null && this.borrowedCount >= 0L) {
            sb.append(",borrowedCount:").append(this.borrowedCount);
        }
        if (this.returnedCount != null && this.returnedCount >= 0L) {
            sb.append(",returnedCount:").append(this.returnedCount);
        }
        sb.append(",createTime:").append(this.createTime);
        sb.append('}');
        return sb.toString();
    }
}

