/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.dbsystem;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.cache.ThreadCache;
import kd.bos.db.dbsystem.InitTask;
import kd.bos.db.dbsystem.InitTaskManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DBSystem {
    private static final Log logger = LogFactory.getLog(DBSystem.class);
    private static ConcurrentHashMap<String, State> map = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> lastExecuteTimeMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Lock> lockMap = new ConcurrentHashMap();

    public static void ensureInited(String accountId) {
        long timeLeast;
        State state = map.get(accountId);
        if (state == null) {
            state = DBSystem.doInited(accountId);
        }
        Long lastExecuteTime = lastExecuteTimeMap.get(accountId);
        if (state.error != null && lastExecuteTime != null && (timeLeast = System.currentTimeMillis() - lastExecuteTime) > 60000L) {
            map.remove(accountId);
            state = DBSystem.doInited(accountId);
        }
        if (state.error != null) {
            logger.error(String.format("DBSystem init failed, accountId=%s, errorInfo=%s", accountId, state.error.getMessage()), (Throwable)state.error);
            throw state.error;
        }
    }

    private static State doInited(String accountId) {
        State state = null;
        try {
            if (!DBSystem.doInit(accountId)) {
                state = map.get(accountId);
            } else {
                state = new State(null);
                map.putIfAbsent(accountId, state);
            }
        }
        catch (Throwable t) {
            state = new State(DBSystem.wrapException(t));
            lastExecuteTimeMap.put(accountId, System.currentTimeMillis());
            map.putIfAbsent(accountId, state);
        }
        return state;
    }

    private static Lock getLock(String accountId) {
        return lockMap.computeIfAbsent(accountId, key -> new ReentrantLock());
    }

    private static boolean doInit(String accountId) {
        Lock lock = DBSystem.getLock(accountId);
        try {
            lock.lock();
            ThreadCache.put((Object)"dbSystemInit", (Object)true);
            if (map.get(accountId) != null) {
                boolean bl = false;
                return bl;
            }
            for (InitTask task : InitTaskManager.getTasks()) {
                task.init(accountId);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw DBSystem.wrapException(e);
        }
        finally {
            lock.unlock();
            ThreadCache.remove((Object)"dbSystemInit");
        }
    }

    private static KDException wrapException(Throwable t) {
        if (t instanceof KDException) {
            return (KDException)t;
        }
        return new KDException(BosErrorCode.systemError, "DBSystem init task error", t);
    }

    static class State {
        KDException error;

        State(KDException error) {
            this.error = error;
        }
    }
}

