/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.extension;

import java.util.List;
import java.util.concurrent.locks.LockSupport;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.extension.DBExtensions;
import kd.bos.extension.ExtensionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DBExtensionsRegister {
    private static final Log logger = LogFactory.getLog((String)DBExtensionsRegister.class.getSimpleName());
    private static ExtensionFactory<DBExtensions> extensionFactory = ExtensionFactory.getExtensionFacotry(DBExtensions.class);

    private DBExtensionsRegister() {
    }

    private static DBExtensions getExtension() {
        try {
            return (DBExtensions)extensionFactory.getExtension(System.getProperty("db.extension.type", "bos"));
        }
        catch (Error | Exception e) {
            logger.error("DBExtensionsRegister init extension implement fail: " + e.getMessage() + ", Starting to exit the service\uff1a", e);
            e.printStackTrace();
            LockSupport.parkNanos(1000000000L);
            System.exit(-1);
            return null;
        }
    }

    public static List<DBConfig> getDBConfigs(String tenantId, String routeKey, String accountId, boolean useCache) {
        return DBExtensionsRegister.getExtension().extendDBConfig(tenantId, routeKey, accountId, useCache);
    }
}

