/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.meta.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.meta.AbstractMeta;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.meta.Column;

public class SqlServerMetaImpl
extends AbstractMeta {
    public static final SqlServerMetaImpl instance = new SqlServerMetaImpl();
    private static final String patten = "^\\((\\((\\d+)\\))|('[\\w ]+')|(\\w+\\(\\))\\)$";

    @Override
    public List<Column> queryColumns(DBRoute dbRoute, String table) {
        StringBuilder sql = new StringBuilder();
        sql.append("select B.name as column_name, T.name as data_type, B.max_length as data_length,B.precision as data_precision,B.scale as data_scale,B.is_nullable as is_nullable,B.column_id as column_id,D.text as column_default ");
        sql.append("from sys.tables A INNER JOIN sys.columns B ON B.object_id = A.object_id INNER JOIN sys.types T on B.user_type_id = T.user_type_id ");
        sql.append("LEFT JOIN sys.extended_properties C ON C.major_id = B.object_id AND C.minor_id = B.column_id ");
        sql.append("LEFT JOIN sys.syscomments D ON D.id = B.default_object_id ");
        sql.append("WHERE A.name = ?  order by column_id");
        String querySql = this.dialect(NoShardingHint.genNoShardingSQL((String)sql.toString()));
        return DB.query(dbRoute, querySql, new Object[]{table.toUpperCase(Locale.ENGLISH)}, rs -> {
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            try {
                while (rs.next()) {
                    Column column = new Column();
                    String column_name = rs.getString("column_name");
                    String dataType = rs.getString("data_type");
                    long data_length = this.parseLongNullAsZero(String.valueOf(rs.getLong("data_length")));
                    int data_precision = this.parseIntNullAsZero(String.valueOf(rs.getLong("data_precision")));
                    int data_scale = this.parseIntNullAsZero(String.valueOf(rs.getLong("data_scale")));
                    boolean nullable = 1 == rs.getInt("is_nullable");
                    int column_id = rs.getInt("column_id");
                    Object column_default = null;
                    String column_default_str = rs.getString("column_default");
                    if (column_default_str != null) {
                        while (column_default_str.startsWith("(")) {
                            if (column_default_str.endsWith(")")) {
                                column_default_str = column_default_str.substring(1, column_default_str.length() - 1);
                                continue;
                            }
                            column_default_str = column_default_str.substring(1);
                        }
                        try {
                            column_default = Long.parseLong(column_default_str);
                        }
                        catch (Exception e) {
                            column_default = column_default_str;
                        }
                    }
                    column.setColumnId(column_id);
                    column.setColumnName(column_name);
                    column.setDataType(dataType);
                    column.setDataDefault(column_default);
                    column.setDataLength(data_length);
                    column.setDataPrecision(data_precision);
                    column.setDataScale(data_scale);
                    column.setNullable(nullable);
                    columnList.add(column);
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
            return columnList;
        });
    }
}

