/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable;

import kd.bos.db.pktemptable.PKTempTableHint;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.ThreadLocals;

public final class PKTempTableHints {
    static final ThreadLocal<PKTempTableHint> hintThreadLocal = ThreadLocals.create();

    private PKTempTableHints() {
    }

    public static PKTempTableHint newHint(int bigStringLength) {
        if (bigStringLength <= 0 || bigStringLength > PKTempTableConfig.getMaxBigStringLength()) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"Parameter bigStringLength is out of range 0-" + PKTempTableConfig.getMaxBigStringLength()});
        }
        PKTempTableHint hint = new PKTempTableHint(bigStringLength);
        PKTempTableHints.set(hint);
        return hint;
    }

    public static PKTempTableHint get() {
        return hintThreadLocal.get();
    }

    static void set(PKTempTableHint hint) {
        hintThreadLocal.set(hint);
    }

    static void clear() {
        hintThreadLocal.remove();
    }
}

