/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.config;

import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.db.pktemptable.PKTempTableHint;
import kd.bos.db.pktemptable.PKTempTableHints;
import kd.bos.db.pktemptable.metric.PKTempTableMetrics;
import kd.bos.util.ConfigurationUtil;

public final class PKTempTableConfig {
    public static final PKTempTableConfig INSTANCE = new PKTempTableConfig();
    private static final int PRODUCE_THREAD_COUNT = Integer.parseInt(System.getProperty("db.temptable.produce_thread_count", "2"));
    private static final int REUSE_THREAD_COUNT = Integer.parseInt(System.getProperty("db.temptable.reuse_thread_count", "1"));
    private static final int BIG_STRING_LENGTH = Integer.parseInt(System.getProperty("db.temptable.big_string_length", "80"));
    private static int MAX_BIG_STRING_LENGTH = 1000;
    private static final int PK_STRING_LENGTH = Integer.parseInt(System.getProperty("db.temptable.pk_string_length", "40"));
    private static final int TABLE_USE_TIMEOUT_MINUTE = Integer.parseInt(System.getProperty("db.temptable.table_use_timeout_minute", "60"));
    private static final int TABLE_SIZE = Integer.parseInt(System.getProperty("db.temptable.table_size", "5"));
    private static final int BIG_STRING_TABLE_SIZE = Integer.parseInt(System.getProperty("db.temptable.big_string_table_size", "1"));
    private static final int MAX_TABLE_SIZE = Integer.parseInt(System.getProperty("db.temptable.max_table_size", "30"));
    private static final int TABLE_CLEAR_TIMEOUT_MINUTE = Integer.parseInt(System.getProperty("db.temptable.table_clear_timeout_minute", "240"));
    private static final boolean REUSE = Boolean.getBoolean("db.temptable.reuse");
    private static final boolean TABLE_CREATE_WITH_PK = Boolean.getBoolean("db.temptable.table_create_with_pk");
    private static final int DROP_RETRY_TIMEOUT_MINUTE = Integer.parseInt(System.getProperty("db.temptable.drop_retry_timeout_minute", "5"));
    private static final boolean MYSQL_USE_DB_DEFAULT_CHARSET = Boolean.parseBoolean(System.getProperty("db.temptable.mysql_use_db_default_charset", "true"));
    private static final String MYSQL_TABLE_CHARSET = System.getProperty("db.temptable.mysql_table_charset", "utf8mb4");
    private static final String MYSQL_TABLE_COLLATE = System.getProperty("db.temptable.mysql_table_collate", "utf8mb4_unicode_ci");
    private static final int CLEAR_SERVICE_SCHEDULE = Integer.parseInt(System.getProperty("db.temptable.clear_schedule_period", "20"));
    private static final int CLEAR_THREAD_COUNT = Integer.parseInt(System.getProperty("db.temptable.clear_thread_count", "2"));
    private static boolean metric = false;
    private static boolean tempWithIndex = true;
    private static boolean mysqlUseLoadInfile = false;
    private static boolean mysqlUseMemoryEngine = false;
    private static boolean sqlServerUseBulk = true;
    private static boolean pgUseCopyIn = true;
    private static boolean pgUseUnloggedTable = true;
    private static boolean yasUseNologging = false;
    private static boolean alwaysValid = true;
    private static boolean newVersion = true;
    private static boolean logRunTimeException = false;
    private static boolean logReleaseStack = false;
    private static boolean txTempTableReuse = false;
    private static int txTempTableMaxSize = 10;
    private static int txTempTableCleanThreshold = 100000;
    private static int dropTimeoutSecond = 20;
    private static int truncateTimeoutSecond = 20;
    private static boolean dmEnableTableVariable = false;
    private static boolean oracleEnableTableVariable = true;
    private static int batchInsertCount = 5000;
    private static int clearRecycleCount = 40;
    private static int clearBatchCount = 5000;

    private PKTempTableConfig() {
    }

    public static int getReuseThreadCount() {
        return REUSE_THREAD_COUNT;
    }

    public static int getProduceThreadCount() {
        return PRODUCE_THREAD_COUNT;
    }

    public static boolean isMysqlUseMemoryEngine() {
        return mysqlUseMemoryEngine;
    }

    public static boolean isMysqlUseLoadInfile() {
        return DataSourceURLs.isAllowLoadLocalInfile() && mysqlUseLoadInfile;
    }

    public static boolean isTempWithIndex() {
        return tempWithIndex;
    }

    public static int getTableSize() {
        return TABLE_SIZE;
    }

    public static int getBigStringLength() {
        PKTempTableHint hint = PKTempTableHints.get();
        if (hint != null) {
            return Math.max(hint.getBigStringLength(), BIG_STRING_LENGTH);
        }
        return BIG_STRING_LENGTH;
    }

    public static int getConfigurationBigStringLength() {
        return BIG_STRING_LENGTH;
    }

    public static boolean isAlwaysValid() {
        return alwaysValid;
    }

    public static int getTableUseTimeoutMinute() {
        if (TABLE_USE_TIMEOUT_MINUTE <= 0) {
            return 60;
        }
        return TABLE_USE_TIMEOUT_MINUTE;
    }

    public static boolean isNewVersion() {
        return newVersion;
    }

    public static boolean isLogRunTimeException() {
        return logRunTimeException;
    }

    public static int getTableClearTimeoutMinute() {
        return TABLE_CLEAR_TIMEOUT_MINUTE;
    }

    public static boolean isReuse() {
        return REUSE;
    }

    public static int getMaxTableSize() {
        return MAX_TABLE_SIZE;
    }

    public static boolean isMetric() {
        return metric;
    }

    public static int getBigStringTableSize() {
        return BIG_STRING_TABLE_SIZE;
    }

    public static int getLogStackThreshold() {
        return Integer.parseInt(System.getProperty("db.temptable.log_stack_threshold", "0"));
    }

    public static boolean isTableCreateWithPk() {
        return TABLE_CREATE_WITH_PK;
    }

    public static int getTxTempTableMaxSize() {
        return txTempTableMaxSize;
    }

    public static int getTxTempTableCleanThreshold() {
        return txTempTableCleanThreshold;
    }

    public static boolean isSqlServerUseBulk() {
        return sqlServerUseBulk;
    }

    public static boolean isPgUseCopyIn() {
        return pgUseCopyIn;
    }

    public static boolean isPgUseUnloggedTable() {
        return pgUseUnloggedTable;
    }

    public static boolean isTxTempTableReuse() {
        return txTempTableReuse && PKTempTableConfig.getTxTempTableMaxSize() > 0;
    }

    public static void setMysqlUseLoadInfile(boolean mysqlUseLoadInfile) {
        PKTempTableConfig.mysqlUseLoadInfile = mysqlUseLoadInfile;
    }

    public static void setSqlServerUseBulk(boolean sqlServerUseBulk) {
        PKTempTableConfig.sqlServerUseBulk = sqlServerUseBulk;
    }

    public static int getDropTimeoutSecond() {
        return dropTimeoutSecond;
    }

    public static int getTruncateTimeoutSecond() {
        return truncateTimeoutSecond;
    }

    public static int getDropRetryTimeoutMinute() {
        return DROP_RETRY_TIMEOUT_MINUTE;
    }

    public static boolean isMysqlUseDbDefaultCharset() {
        return MYSQL_USE_DB_DEFAULT_CHARSET;
    }

    public static String getMysqlTableCharset() {
        return MYSQL_TABLE_CHARSET;
    }

    public static String getMysqlTableCollate() {
        return MYSQL_TABLE_COLLATE;
    }

    public static int getPkStringLength() {
        if (PK_STRING_LENGTH < 32) {
            return 32;
        }
        return PK_STRING_LENGTH;
    }

    public static boolean isDmEnableTableVariable() {
        return dmEnableTableVariable;
    }

    public static boolean isLogReleaseStack() {
        return logReleaseStack;
    }

    public static int getBatchInsertCount() {
        return batchInsertCount;
    }

    public static int getClearServiceSchedule() {
        return CLEAR_SERVICE_SCHEDULE;
    }

    public static int getClearThreadCount() {
        return CLEAR_THREAD_COUNT;
    }

    public static int getClearRecycleCount() {
        return clearRecycleCount;
    }

    public static int getClearBatchCount() {
        return clearBatchCount;
    }

    public static int getMaxBigStringLength() {
        return MAX_BIG_STRING_LENGTH;
    }

    public static boolean isOracleEnableTableVariable() {
        return oracleEnableTableVariable;
    }

    public static boolean isYasUseNologging() {
        return yasUseNologging;
    }

    static {
        ConfigurationUtil.observeBoolean((String)"db.temptable.mysql_use_memory_engine", (boolean)false, v -> {
            mysqlUseMemoryEngine = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.mysql_use_load_infile", (boolean)false, v -> {
            mysqlUseLoadInfile = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.sql_server_use_bulk", (boolean)true, v -> {
            sqlServerUseBulk = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.pg_use_copy_in", (boolean)pgUseCopyIn, v -> {
            pgUseCopyIn = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.pg.use_unlogged_table", (boolean)pgUseUnloggedTable, v -> {
            pgUseUnloggedTable = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.yas.use_unlogged_table", (boolean)yasUseNologging, v -> {
            yasUseNologging = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.with_index", (boolean)true, v -> {
            tempWithIndex = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.always_valid", (boolean)true, v -> {
            alwaysValid = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.new_version", (boolean)newVersion, v -> {
            newVersion = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.log_runtime_exception", (boolean)false, v -> {
            logRunTimeException = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.log_release_stack", (boolean)logReleaseStack, v -> {
            logReleaseStack = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.metric", (boolean)false, v -> {
            metric = v;
            PKTempTableMetrics.getDefault().enableMetric(metric);
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.dm_enable_table_variable", (boolean)false, v -> {
            dmEnableTableVariable = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.oracle_enable_table_variable", (boolean)true, v -> {
            oracleEnableTableVariable = v;
        });
        ConfigurationUtil.observeInteger((String)"db.temptable.tx_temptable_maxsize", (int)txTempTableMaxSize, v -> {
            txTempTableMaxSize = v;
        });
        ConfigurationUtil.observeInteger((String)"db.temptable.tx_temptable_clean_threshold", (int)txTempTableCleanThreshold, v -> {
            txTempTableCleanThreshold = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.temptable.tx_temptable_reuse", (boolean)txTempTableReuse, v -> {
            txTempTableReuse = v;
        });
        ConfigurationUtil.observeInteger((String)"db.temptable.drop_timeout_second", (int)dropTimeoutSecond, v -> {
            dropTimeoutSecond = v;
        });
        ConfigurationUtil.observeInteger((String)"db.temptable.truncate_timeout_second", (int)truncateTimeoutSecond, v -> {
            truncateTimeoutSecond = v;
        });
        ConfigurationUtil.observeInteger((String)"db.temptable.batch_insert_count", (int)batchInsertCount, v -> {
            batchInsertCount = Math.abs(v);
        });
        ConfigurationUtil.observeInteger((String)"db.temptable.clear_recycle_count", (int)clearRecycleCount, v -> {
            clearRecycleCount = Math.abs(v);
        });
        ConfigurationUtil.observeInteger((String)"db.temptable.clear_batch_count", (int)clearBatchCount, v -> {
            clearBatchCount = Math.abs(v);
        });
        ConfigurationUtil.observeInteger((String)"db.temptable.max_big_string_length", (int)MAX_BIG_STRING_LENGTH, v -> {
            MAX_BIG_STRING_LENGTH = Math.abs(v);
        });
    }
}

