/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.metric;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kd.bos.db.pktemptable.metric.MetricListener;
import kd.bos.db.pktemptable.metric.PKTempTableConfigSnapshot;
import kd.bos.db.pktemptable.metric.PKTempTableMXBean;
import kd.bos.db.pktemptable.metric.wrapper.DynamicCounterWrapper;
import kd.bos.db.pktemptable.metric.wrapper.DynamicHistogramWrapper;
import kd.bos.db.pktemptable.metric.wrapper.JmxHistogramSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKTempTableMXBeanImpl
implements PKTempTableMXBean,
MetricListener {
    private static final PKTempTableMXBeanImpl INSTANCE = new PKTempTableMXBeanImpl();
    private static final Logger log = LoggerFactory.getLogger(PKTempTableMXBeanImpl.class);
    private final DynamicCounterWrapper tableQueueCounter = new DynamicCounterWrapper();
    private final DynamicCounterWrapper dropQueueCounter = new DynamicCounterWrapper();
    private final DynamicCounterWrapper reuseQueueCounter = new DynamicCounterWrapper();
    private final DynamicCounterWrapper timeCheckQueueCounter = new DynamicCounterWrapper();
    private final DynamicHistogramWrapper createTableHistogram = new DynamicHistogramWrapper();
    private final DynamicHistogramWrapper dropTableHistogram = new DynamicHistogramWrapper();
    private final DynamicHistogramWrapper truncateTableHistogram = new DynamicHistogramWrapper();
    private final DynamicHistogramWrapper takeTableHistogram = new DynamicHistogramWrapper();

    public static PKTempTableMXBeanImpl getInstance() {
        return INSTANCE;
    }

    public DynamicCounterWrapper getTableQueueCounter() {
        return this.tableQueueCounter;
    }

    public DynamicCounterWrapper getDropQueueCounter() {
        return this.dropQueueCounter;
    }

    public DynamicCounterWrapper getReuseQueueCounter() {
        return this.reuseQueueCounter;
    }

    public DynamicCounterWrapper getTimeCheckQueueCounter() {
        return this.timeCheckQueueCounter;
    }

    public PKTempTableMXBeanImpl() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("kd.bos.db:name=PkTempTable"));
        }
        catch (Exception e) {
            log.warn("register PKTempTableMXBeanImpl MXBean error,msg:{}.", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public long getReadyTableSize() {
        return this.tableQueueCounter.getCount();
    }

    @Override
    public long getUsingTableSize() {
        return this.timeCheckQueueCounter.getCount();
    }

    @Override
    public long getToDropTableSize() {
        return this.dropQueueCounter.getCount();
    }

    @Override
    public long getToReuseTableSize() {
        return this.reuseQueueCounter.getCount();
    }

    public DynamicHistogramWrapper getCreateTableHistogram() {
        return this.createTableHistogram;
    }

    public DynamicHistogramWrapper getDropTableHistogram() {
        return this.dropTableHistogram;
    }

    public DynamicHistogramWrapper getTruncateTableHistogram() {
        return this.truncateTableHistogram;
    }

    public DynamicHistogramWrapper getTakeTableHistogram() {
        return this.takeTableHistogram;
    }

    @Override
    public JmxHistogramSnapshot getCreateTableCost() {
        return new JmxHistogramSnapshot(this.createTableHistogram.getSnapshot());
    }

    @Override
    public JmxHistogramSnapshot getDropTableCost() {
        return new JmxHistogramSnapshot(this.dropTableHistogram.getSnapshot());
    }

    @Override
    public JmxHistogramSnapshot getTruncateTableCost() {
        return new JmxHistogramSnapshot(this.truncateTableHistogram.getSnapshot());
    }

    @Override
    public JmxHistogramSnapshot getGetTableCost() {
        return new JmxHistogramSnapshot(this.takeTableHistogram.getSnapshot());
    }

    @Override
    public PKTempTableConfigSnapshot getConfig() {
        return PKTempTableConfigSnapshot.snapshot();
    }

    @Override
    public void start() {
        this.tableQueueCounter.start();
        this.dropQueueCounter.start();
        this.reuseQueueCounter.start();
        this.timeCheckQueueCounter.start();
        this.createTableHistogram.start();
        this.dropTableHistogram.start();
        this.truncateTableHistogram.start();
        this.takeTableHistogram.start();
    }

    @Override
    public void stop() {
        this.tableQueueCounter.stop();
        this.dropQueueCounter.stop();
        this.reuseQueueCounter.stop();
        this.timeCheckQueueCounter.stop();
        this.createTableHistogram.stop();
        this.dropTableHistogram.stop();
        this.truncateTableHistogram.stop();
        this.takeTableHistogram.stop();
    }
}

