/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.metric.wrapper;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import kd.bos.db.pktemptable.metric.MetricListener;
import kd.bos.metric.Counter;

public class DynamicCounterWrapper
extends Counter
implements MetricListener {
    private final AtomicBoolean enable = new AtomicBoolean(false);
    private final LongAdder counter = new LongAdder();

    public DynamicCounterWrapper() {
        super(null);
    }

    public void inc() {
        if (this.enable.get()) {
            this.counter.increment();
        }
    }

    public void inc(long n) {
        if (this.enable.get()) {
            this.counter.add(n);
        }
    }

    public void dec() {
        if (this.enable.get()) {
            this.counter.decrement();
        }
    }

    public void dec(long n) {
        if (this.enable.get()) {
            this.counter.add(-n);
        }
    }

    public long getCount() {
        if (this.enable.get()) {
            return this.counter.longValue();
        }
        return 0L;
    }

    @Override
    public final void start() {
        this.enable.set(true);
    }

    @Override
    public final void stop() {
        this.enable.set(false);
        this.counter.reset();
    }
}

