/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.pktemptable.PKTempTableType;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.metric.PKTempTableCostMetric;
import kd.bos.db.pktemptable.metric.PKTempTableMetric;
import kd.bos.db.pktemptable.metric.PKTempTableMetrics;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.service.Limiter;
import kd.bos.db.pktemptable.service.PKTempTableAsyncDropService;
import kd.bos.db.pktemptable.service.PKTempTableAsyncReuseService;
import kd.bos.db.pktemptable.service.PKTempTableCoreService;
import kd.bos.db.pktemptable.service.PKTempTableDropRequest;
import kd.bos.db.pktemptable.table.PKTempTableOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerPKTempTableImpl
implements InnerPKTempTable {
    private static final Logger log = LoggerFactory.getLogger(InnerPKTempTableImpl.class);
    private final LocalDateTime createTime;
    private final String name;
    private final PKTempTableType type;
    private final RequestContextInfo rc;
    private final DBRoute route;
    private final PKTempTableOperator operator;
    private final PKTempTableAsyncDropService dropService = PKTempTableAsyncDropService.getInstance();
    private final PKTempTableAsyncReuseService reuseService = PKTempTableAsyncReuseService.getInstance();
    private final PKTempTableCoreService coreService;
    private final PKTempTableMetric metric = PKTempTableMetrics.getDefault();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private boolean reuse = true;

    private InnerPKTempTableImpl(PKTempTableCoreService service, String name, PKTempTableType type, RequestContextInfo rc, DBRoute route, PKTempTableOperator operator) {
        this.createTime = LocalDateTime.now();
        this.name = name;
        this.type = type;
        this.rc = rc;
        this.route = route;
        this.operator = operator;
        this.coreService = service;
    }

    /*
     * Exception decompiling
     */
    public static InnerPKTempTableImpl create(PKTempTableCoreService service, PKTempTableType type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean valid() {
        int clearTimeMinute = PKTempTableConfig.getTableClearTimeoutMinute();
        if (LocalDateTime.now().plusMinutes(PKTempTableConfig.getTableUseTimeoutMinute()).isAfter(this.createTime.plusMinutes(clearTimeMinute - 1))) {
            return false;
        }
        if (PKTempTableConfig.isAlwaysValid()) {
            return this.operator.validTable(this.route, this.name);
        }
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PKTempTableType getType() {
        return this.type;
    }

    @Override
    public RequestContextInfo getContext() {
        return this.rc;
    }

    @Override
    public DBRoute getRoute() {
        return this.route;
    }

    @Override
    public void close() {
        if (PKTempTableConfig.isLogReleaseStack()) {
            log.info("temptable release log: " + this.name, (Throwable)new RuntimeException(this.name + " release stack"));
        }
        if (this.closed.compareAndSet(false, true)) {
            if (PKTempTableConfig.isReuse() && this.reuse) {
                this.reuseService.offer(this);
            } else {
                this.asyncDrop();
            }
        }
    }

    @Override
    public void onUsing() {
        this.closed.set(false);
    }

    @Override
    public void asyncDrop() {
        this.dropService.offer(new PKTempTableDropRequest(this.rc, this.route, this.name, this.operator, true));
    }

    @Override
    public void reuseImmediate() {
        try (PKTempTableCostMetric ignored = this.metric.truncateTable();
             AutoCloseable ignored1 = this.rc.setupThreadRequestContext();){
            if (this.coreService.canReuse(this.type)) {
                this.operator.truncate(this.route, this);
                if (this.coreService.reuse(this)) {
                    return;
                }
            }
            this.asyncDrop();
        }
        catch (Exception ex) {
            if (PKTempTableConfig.isLogRunTimeException()) {
                log.warn("PKTempTable:{} reuse fail,msg:{}", new Object[]{this.name, ex.getMessage(), ex});
            }
            this.asyncDrop();
        }
    }

    @Override
    public void clear(int version) {
        this.operator.delete(this.route, this, Sets.newHashSet((Object[])new Integer[]{this.getVersion()}));
    }

    public String toString() {
        return "PKTempTable::" + this.name + '#' + (Object)((Object)this.type) + '#' + this.route.getRouteKey() + '#' + this.rc;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void insert(Collection<?> pks, int version) {
        try (Limiter.Ticket ticket = Limiter.acquire(Limiter.Action.INSERT_DATA, this.route.getRouteKey());){
            this.operator.insert(this.route, this, pks, version);
        }
    }

    @Override
    public void close(int version) {
        this.close();
    }

    @Override
    public boolean isReuseInTx() {
        return false;
    }

    @Override
    public void setReuse(boolean reuse) {
        this.reuse = reuse;
    }
}

