/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.db.pktemptable.metric.PKTempTableMetrics;
import kd.bos.db.pktemptable.service.AbstractPKTempTableDaemonService;
import kd.bos.db.pktemptable.service.PKTempTableDropRequest;
import kd.bos.metric.Counter;

public class PKTempTableAsyncDropService
extends AbstractPKTempTableDaemonService {
    private static final PKTempTableAsyncDropService INSTANCE = new PKTempTableAsyncDropService();
    private final LinkedBlockingQueue<PKTempTableDropRequest> queue = new LinkedBlockingQueue();
    private final Counter counter = PKTempTableMetrics.getDefault().asyncDropQueueCounter();

    PKTempTableAsyncDropService() {
        super("PKTempTableAsyncDropService");
    }

    public static PKTempTableAsyncDropService getInstance() {
        return INSTANCE;
    }

    public void offer(PKTempTableDropRequest request) {
        boolean result = this.queue.offer(request);
        if (result) {
            this.counter.inc();
        }
    }

    @Override
    protected void doTask() throws InterruptedException {
        PKTempTableDropRequest request = this.queue.poll(10L, TimeUnit.SECONDS);
        if (request != null) {
            request.dropImmediate();
            this.counter.dec();
        }
    }

    @Override
    protected long pauseMillis() {
        return 0L;
    }

    @Override
    protected long getDelayStartMillis() {
        return 0L;
    }
}

