/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.metric.PKTempTableMetrics;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.service.PKTempTableDaemonService;
import kd.bos.db.pktemptable.utils.DiscardUtil;
import kd.bos.db.pktemptable.utils.ExecutorServiceUtil;
import kd.bos.db.pktemptable.utils.PKTempTableThreadUtils;
import kd.bos.metric.Counter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKTempTableAsyncReuseService
implements PKTempTableDaemonService {
    private static final Logger log = LoggerFactory.getLogger(PKTempTableAsyncReuseService.class);
    private static final PKTempTableAsyncReuseService INSTANCE = new PKTempTableAsyncReuseService();
    private final LinkedBlockingQueue<InnerPKTempTable> queue = new LinkedBlockingQueue();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Counter counter = PKTempTableMetrics.getDefault().asyncReuseQueueCounter();

    static PKTempTableAsyncReuseService getInstance() {
        return INSTANCE;
    }

    public void offer(InnerPKTempTable table) {
        boolean result = this.queue.offer(table);
        if (result) {
            this.counter.inc();
        }
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.start0();
        }
    }

    private void start0() {
        ExecutorService executorService = ExecutorServiceUtil.newFixExecutorService(PKTempTableConfig.getReuseThreadCount(), this.getClass().getSimpleName());
        for (int i = 0; i < PKTempTableConfig.getReuseThreadCount(); ++i) {
            executorService.submit(() -> {
                while (true) {
                    PKTempTableThreadUtils.resetThread();
                    try {
                        InnerPKTempTable result = this.queue.poll(10L, TimeUnit.SECONDS);
                        if (result == null) continue;
                        result.reuseImmediate();
                        this.counter.dec();
                        continue;
                    }
                    catch (Exception ex) {
                        block6: {
                            log.warn("PKTempTableTask:{} execute exception,msg: {}", new Object[]{Thread.currentThread().getName(), ex.getMessage(), ex});
                            if (!(ex instanceof InterruptedException)) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException ex1) {
                                    DiscardUtil.discard(ex1);
                                    break block6;
                                }
                                continue;
                            }
                        }
                        return;
                    }
                    break;
                }
            });
        }
    }
}

