/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.service.PKTempTableDaemonService;
import kd.bos.db.pktemptable.service.PKTempTableDropRequestGroup;
import kd.bos.db.pktemptable.service.PKTempTableRuntimeContext;
import kd.bos.db.pktemptable.table.PKTempTableOperatorFactory;
import kd.bos.db.pktemptable.utils.ExecutorServiceUtil;
import kd.bos.db.pktemptable.utils.PKTempTableMetaUtils;
import kd.bos.db.pktemptable.utils.PKTempTableThreadUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKTempTableClearService
implements PKTempTableDaemonService {
    private static final Logger log = LoggerFactory.getLogger(PKTempTableClearService.class);
    public static final PKTempTableClearService INSTANCE = new PKTempTableClearService();
    private final AtomicBoolean started = new AtomicBoolean(false);

    static PKTempTableClearService getInstance() {
        return INSTANCE;
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            Elector elector = ElectFactory.getElector((String)this.getClass().getName());
            elector.registerListener((ElectorListener)new ElectorListener4ClearService());
            elector.start();
        }
    }

    public static class Statistics {
        private final Map<String, List<ClearTaskResult>> results = new HashMap<String, List<ClearTaskResult>>();

        public void add(ClearTaskResult result) {
            RequestContextInfo rc = result.getContext().getRc();
            String key = rc.getTenantId() + '#' + rc.getAccountId();
            List results = this.results.computeIfAbsent(key, k -> new ArrayList());
            results.add(result);
        }

        public void logAllStatistics() {
            for (Map.Entry<String, List<ClearTaskResult>> entry : this.results.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                StringBuilder builder = new StringBuilder("Statistics for clear temptable on ").append(entry.getKey()).append(":\r\n");
                builder.append("routeKey,clearCount,cost(ms)\r\n");
                RowMeta rowMeta = new RowMeta(new Field[]{new Field("routeKey", (DataType)DataType.StringType), new Field("count", (DataType)DataType.IntegerType), new Field("cost", (DataType)DataType.LongType)});
                final Iterator<ClearTaskResult> inputIte = entry.getValue().iterator();
                try (AlgoContext context = Algo.newContext();){
                    DataSet dataSet = Algo.create((String)PKTempTableClearService.class.getSimpleName()).createDataSet((Iterator)new Iterator<Object[]>(){

                        @Override
                        public boolean hasNext() {
                            return inputIte.hasNext();
                        }

                        @Override
                        public Object[] next() {
                            ClearTaskResult result = (ClearTaskResult)inputIte.next();
                            return new Object[]{result.getContext().getRoute().getRouteKey(), result.getClearTableCount(), result.getCost()};
                        }
                    }, rowMeta);
                    dataSet = dataSet.orderBy(new String[]{"count desc", "cost desc"});
                    for (Row row : dataSet) {
                        builder.append(row.getString(0)).append(',');
                        builder.append(row.getInteger(1)).append(',');
                        builder.append(row.getLong(2)).append("\r\n");
                    }
                }
                log.info(builder.toString());
            }
        }
    }

    public static class ClearTaskResult {
        private PKTempTableRuntimeContext.Context context;
        private int clearTableCount;
        private boolean retry;
        private long cost;

        public ClearTaskResult(PKTempTableRuntimeContext.Context context) {
            this.context = context;
        }

        public void setContext(PKTempTableRuntimeContext.Context context) {
            this.context = context;
        }

        public void setClearTableCount(int clearTableCount) {
            this.clearTableCount = clearTableCount;
        }

        public void setRetry(boolean retry) {
            this.retry = retry;
        }

        public long getCost() {
            return this.cost;
        }

        public void setCost(long cost) {
            this.cost = cost;
        }

        public PKTempTableRuntimeContext.Context getContext() {
            return this.context;
        }

        public int getClearTableCount() {
            return this.clearTableCount;
        }

        public boolean isRetry() {
            return this.retry;
        }
    }

    public static class ClearTask
    implements Runnable {
        private final CompletableFuture<ClearTaskResult> completableFuture = new CompletableFuture();
        private final PKTempTableRuntimeContext.Context context;

        public ClearTask(PKTempTableRuntimeContext.Context context) {
            this.context = context;
        }

        public CompletableFuture<ClearTaskResult> getCompletableFuture() {
            return this.completableFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PKTempTableThreadUtils.resetThread();
            ClearTaskResult clearTaskResult = new ClearTaskResult(this.context);
            clearTaskResult.setRetry(false);
            clearTaskResult.setClearTableCount(0);
            clearTaskResult.setCost(0L);
            long start = System.currentTimeMillis();
            try (AutoCloseable ignored = this.context.getRc().setupThreadRequestContext();){
                int batch = PKTempTableConfig.getClearBatchCount();
                int maxRecycleCount = PKTempTableConfig.getClearRecycleCount();
                int clearCount = 0;
                for (int recycleCount = 0; recycleCount < maxRecycleCount; ++recycleCount) {
                    if (Thread.currentThread().isInterrupted()) {
                        log.warn("Clear task will be existed, current thread has been interrupted.");
                        clearTaskResult.setCost(System.currentTimeMillis() - start);
                        return;
                    }
                    List<String> tableNames = this.queryTimeoutTable(this.context.getRoute(), batch);
                    if (tableNames.isEmpty()) break;
                    clearCount += tableNames.size();
                    new PKTempTableDropRequestGroup(this.context.getRc(), this.context.getRoute(), tableNames, this.context.getOperator()).dropImmediate();
                }
                if (clearCount >= batch * maxRecycleCount) {
                    clearTaskResult.setRetry(true);
                }
                clearTaskResult.setClearTableCount(clearCount);
            }
            catch (Exception ex) {
                log.warn("Clear task fail on {}, msg:{}", new Object[]{this.context.toString(), ex.getMessage(), ex});
                clearTaskResult.setCost(System.currentTimeMillis() - start);
                clearTaskResult.setRetry(false);
            }
            finally {
                clearTaskResult.setCost(System.currentTimeMillis() - start);
                this.completableFuture.complete(clearTaskResult);
            }
        }

        private List<String> queryTimeoutTable(DBRoute route, int top) {
            try {
                return PKTempTableMetaUtils.queryTimeoutList(route, top);
            }
            catch (Exception e) {
                if (e instanceof KDException && ((KDException)e).getErrorCode() == BosErrorCode.sQLTableNotExist) {
                    PKTempTableMetaUtils.initMetaTable(route, RequestContextInfo.get());
                }
                return Collections.emptyList();
            }
        }
    }

    public static class ElectorListener4ClearService
    implements ElectorListener {
        private ScheduledExecutorService reuseExecutor;
        private ExecutorService dropExecutor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyMaster() {
            ElectorListener4ClearService electorListener4ClearService = this;
            synchronized (electorListener4ClearService) {
                log.info("Start temptable clear service");
                if (this.dropExecutor == null) {
                    this.dropExecutor = ExecutorServiceUtil.newFixExecutorService(PKTempTableConfig.getClearThreadCount(), PKTempTableClearService.class.getSimpleName() + "-worker-");
                }
                if (this.reuseExecutor == null) {
                    this.reuseExecutor = ExecutorServiceUtil.newSingleThreadScheduledExecutor(PKTempTableClearService.class.getSimpleName());
                    this.reuseExecutor.scheduleWithFixedDelay(this::clear, this.getDelayStartMillis(), this.getSchedulePeriod(), TimeUnit.MILLISECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyLostMaster() {
            ElectorListener4ClearService electorListener4ClearService = this;
            synchronized (electorListener4ClearService) {
                if (this.reuseExecutor != null) {
                    this.reuseExecutor.shutdownNow();
                    this.reuseExecutor = null;
                }
                if (this.dropExecutor != null) {
                    this.dropExecutor.shutdownNow();
                    this.dropExecutor = null;
                }
            }
        }

        public void clear() {
            PKTempTableThreadUtils.resetThread();
            boolean retry = false;
            do {
                List<PKTempTableRuntimeContext.Context> runs;
                if ((runs = this.loadRuntimeContext()).isEmpty()) {
                    log.warn("The Clear service is not running, and the runtime context is empty.");
                    return;
                }
                if (Thread.currentThread().isInterrupted()) {
                    log.warn("Current thread is interrupted, clear task will be stopped.");
                    return;
                }
                ArrayList<CompletableFuture<ClearTaskResult>> completableFutures = new ArrayList<CompletableFuture<ClearTaskResult>>(runs.size());
                for (PKTempTableRuntimeContext.Context each : runs) {
                    ClearTask clearTask = new ClearTask(each);
                    this.dropExecutor.submit(clearTask);
                    completableFutures.add(clearTask.getCompletableFuture());
                }
                try {
                    CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
                    Statistics statistics = new Statistics();
                    for (CompletableFuture completableFuture : completableFutures) {
                        ClearTaskResult clearTaskResult = (ClearTaskResult)completableFuture.get();
                        if (clearTaskResult.isRetry()) {
                            retry = true;
                        }
                        statistics.add(clearTaskResult);
                    }
                    statistics.logAllStatistics();
                }
                catch (InterruptedException | ExecutionException e) {
                    log.warn("The clear task receive an exception during execution, error is: " + e.getMessage());
                }
            } while (retry);
        }

        private List<PKTempTableRuntimeContext.Context> loadRuntimeContext() {
            try {
                List<Account> accounts = AccountUtils.getAllAccountsOfCurrentEnv();
                ArrayList<DBConfig> dbConfigs = new ArrayList<DBConfig>();
                for (Account account : accounts) {
                    if (account == null || account.getDBInstanceList() == null) continue;
                    List<DBInstance> dbInstances = account.getDBInstanceList();
                    Iterator<DBInstance> iterator = dbInstances.iterator();
                    block5: while (iterator.hasNext()) {
                        DBInstance dbInstance = iterator.next();
                        List<DBConfig> readWriteList = null;
                        try {
                            readWriteList = DBConfig.loadFromDataCenter(account.getTenantId(), dbInstance.getRouteKey(), account.getAccountId(), true);
                        }
                        catch (Throwable ig) {
                            continue;
                        }
                        for (DBConfig dbConfig : readWriteList) {
                            if (dbConfig.isReadOnly()) continue;
                            dbConfigs.add(dbConfig);
                            continue block5;
                        }
                    }
                }
                ArrayList<DBConfig> runtimeConfigs = new ArrayList<DBConfig>(dbConfigs.size());
                HashSet<String> shardingIdContainer = new HashSet<String>(dbConfigs.size());
                for (DBConfig dbConfig : dbConfigs) {
                    if (shardingIdContainer.contains(dbConfig.getSharingId())) continue;
                    shardingIdContainer.add(dbConfig.getSharingId());
                    runtimeConfigs.add(dbConfig);
                }
                ArrayList<PKTempTableRuntimeContext.Context> result = new ArrayList<PKTempTableRuntimeContext.Context>(runtimeConfigs.size());
                for (DBConfig runtimeConfig : runtimeConfigs) {
                    result.add(new PKTempTableRuntimeContext.Context(new RequestContextInfo(runtimeConfig.getTenantId(), runtimeConfig.getAccountId()), DBRoute.of(runtimeConfig.getRouteKey()), PKTempTableOperatorFactory.get(runtimeConfig.getDBType())));
                }
                return result;
            }
            catch (Throwable ignored) {
                return Collections.emptyList();
            }
        }

        private long getDelayStartMillis() {
            return ThreadLocalRandom.current().nextInt(1, 60) * 1000;
        }

        private int getSchedulePeriod() {
            return PKTempTableConfig.getClearServiceSchedule() * 60 * 1000;
        }
    }
}

