/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.db.pktemptable.service.AbstractPKTempTableDaemonService;
import kd.bos.db.pktemptable.service.PKTempTableAsyncDropService;
import kd.bos.db.pktemptable.service.PKTempTableDropRequest;
import kd.bos.db.pktemptable.utils.DiscardUtil;

public class PKTempTableDropDelayService
extends AbstractPKTempTableDaemonService {
    private static final PKTempTableDropDelayService INSTANCE = new PKTempTableDropDelayService();
    private final LinkedBlockingQueue<PKTempTableDropRequest> queue = new LinkedBlockingQueue();
    private final PKTempTableAsyncDropService dropService = PKTempTableAsyncDropService.getInstance();

    PKTempTableDropDelayService() {
        super("PKTempTableDropRetryService");
    }

    static PKTempTableDropDelayService getInstance() {
        return INSTANCE;
    }

    public void offer(PKTempTableDropRequest request) {
        boolean success = this.queue.offer(request);
        DiscardUtil.discard(success);
    }

    @Override
    protected void doTask() throws InterruptedException {
        PKTempTableDropRequest request = this.queue.peek();
        if (request != null && request.canDropRetry()) {
            this.queue.poll();
            this.dropService.offer(request);
        } else {
            this.sleep(10000L);
        }
    }

    @Override
    protected long pauseMillis() {
        return 10L;
    }

    @Override
    protected long getDelayStartMillis() {
        return 0L;
    }
}

