/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.pktemptable.PKTempTableType;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.service.PKTempTableCoreService;
import kd.bos.db.pktemptable.service.PKTempTableDaemonService;
import kd.bos.db.pktemptable.service.PKTempTableProducerRequest;
import kd.bos.db.pktemptable.utils.ExecutorServiceUtil;
import kd.bos.db.pktemptable.utils.PKTempTableThreadUtils;

public class PKTempTableProducerService
implements PKTempTableDaemonService {
    private static final PKTempTableProducerService INSTANCE = new PKTempTableProducerService();
    private final ArrayBlockingQueue<PKTempTableProducerRequest> queue = new ArrayBlockingQueue(4096);
    private final AtomicBoolean started = new AtomicBoolean(false);

    static PKTempTableProducerService getInstance() {
        return INSTANCE;
    }

    private void start0() {
        ExecutorService executorService = ExecutorServiceUtil.newFixExecutorService(PKTempTableConfig.getProduceThreadCount(), this.getClass().getSimpleName());
        for (int i = 0; i < PKTempTableConfig.getProduceThreadCount(); ++i) {
            executorService.submit(this::consumer);
        }
    }

    public void postRequest(PKTempTableCoreService service, PKTempTableType type) {
        if (service.queueSize(type) < PKTempTableConfig.getTableSize()) {
            this.queue.offer(PKTempTableProducerRequest.from(service, type));
        }
    }

    private void consumer() {
        while (!Thread.interrupted()) {
            PKTempTableThreadUtils.resetThread();
            try {
                PKTempTableProducerRequest request = this.queue.poll(10L, TimeUnit.SECONDS);
                if (request == null) continue;
                request.produce();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.start0();
        }
    }
}

