/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.pktemptable.PKTempTableType;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.service.PKTempTableCoreService;
import kd.bos.db.pktemptable.service.tx.InnerPKTempTableReuseInTx;
import kd.bos.db.pktemptable.service.tx.InnerPKTempTableReuseInTxImpl;
import kd.bos.db.pktemptable.service.tx.ReuseInTxSortStrategy;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXContext;

public class PKTempTableReuseInTXService
implements AutoCloseable {
    private static final ThreadLocal<Map<TXContext, TXReleaseListener>> THREAD_RELEASE_LISTENER = new ThreadLocal();
    private static final ThreadLocal<Map<TXContext, TableCache>> THREAD_TABLE_CACHE = new ThreadLocal();
    private final PKTempTableCoreService coreService;

    PKTempTableReuseInTXService(PKTempTableCoreService coreService) {
        this.coreService = coreService;
    }

    public InnerPKTempTable borrow(PKTempTableType type) {
        TableCache tableCache = this.getCurrentTXTableCache();
        InnerPKTempTableReuseInTx table = tableCache.get(type);
        if (table == null) {
            return this.getTableImmediate(type);
        }
        return table;
    }

    private InnerPKTempTable getTableImmediate(PKTempTableType type) {
        InnerPKTempTable inner = this.coreService.getTableImmediate(type);
        InnerPKTempTableReuseInTxImpl table = new InnerPKTempTableReuseInTxImpl(inner, this.coreService.getOperator());
        this.register(table);
        return table;
    }

    private TableCache getCurrentTXTableCache() {
        TXContext rootContext;
        TableCache tableCache;
        Map<TXContext, TableCache> map = THREAD_TABLE_CACHE.get();
        if (map == null) {
            map = new HashMap<TXContext, TableCache>(8);
            THREAD_TABLE_CACHE.set(map);
        }
        if ((tableCache = map.get(rootContext = TX.__getTXContext().__peekTMRoot())) == null) {
            tableCache = new TableCache();
            map.put(rootContext, tableCache);
        }
        return tableCache;
    }

    private TXReleaseListener getCurrentTXReleaseListener() {
        TXContext rootContext;
        TXReleaseListener listener;
        Map<TXContext, TXReleaseListener> map = THREAD_RELEASE_LISTENER.get();
        if (map == null) {
            map = new HashMap<TXContext, TXReleaseListener>(8);
            THREAD_RELEASE_LISTENER.set(map);
        }
        if ((listener = map.get(rootContext = TX.__getTXContext().__peekTMRoot())) == null) {
            listener = new TXReleaseListener(this, rootContext);
            map.put(rootContext, listener);
        }
        return listener;
    }

    private void register(InnerPKTempTableReuseInTx table) {
        TXReleaseListener listener = this.getCurrentTXReleaseListener();
        listener.register(table);
        this.getCurrentTXTableCache().put(table);
    }

    @Override
    public void close() {
        if (THREAD_TABLE_CACHE.get().isEmpty()) {
            THREAD_RELEASE_LISTENER.remove();
            THREAD_TABLE_CACHE.remove();
        }
    }

    private static class TXReleaseListener
    implements CommitListener {
        private final Set<InnerPKTempTableReuseInTx> tables = new HashSet<InnerPKTempTableReuseInTx>();
        private final PKTempTableReuseInTXService txManagerService;
        private final TXContext rootContext;

        public TXReleaseListener(PKTempTableReuseInTXService txManagerService, TXContext rootContext) {
            this.txManagerService = txManagerService;
            this.rootContext = rootContext;
            TX.addCommitListener(this);
        }

        @Override
        public void onEnded(boolean rollbacked) {
            this.afterCommit(this.rootContext);
            for (InnerPKTempTableReuseInTx table : this.tables) {
                table.close();
            }
            this.tables.clear();
            this.txManagerService.close();
        }

        private void afterCommit(TXContext rootContext) {
            ((Map)THREAD_TABLE_CACHE.get()).remove(rootContext);
            ((Map)THREAD_RELEASE_LISTENER.get()).remove(rootContext);
        }

        public void register(InnerPKTempTableReuseInTx table) {
            this.tables.add(table);
        }
    }

    private static class TableCache {
        private final ReuseInTxSortStrategy sortStrategy = ReuseInTxSortStrategy.getInstance();
        private final Map<PKTempTableType, Set<InnerPKTempTableReuseInTx>> shareList = new EnumMap<PKTempTableType, Set<InnerPKTempTableReuseInTx>>(PKTempTableType.class);

        private TableCache() {
        }

        private void put(InnerPKTempTableReuseInTx table) {
            Set shardSet = this.shareList.computeIfAbsent(table.getType(), k -> new HashSet());
            shardSet.add(table);
        }

        private InnerPKTempTableReuseInTx get(PKTempTableType type) {
            Set<InnerPKTempTableReuseInTx> shareSet = this.shareList.get((Object)type);
            if (shareSet == null || shareSet.isEmpty() || shareSet.size() < PKTempTableConfig.getTxTempTableMaxSize()) {
                return null;
            }
            List<InnerPKTempTableReuseInTx> list = new ArrayList<InnerPKTempTableReuseInTx>(shareSet);
            list = this.sortStrategy.sort(list);
            for (InnerPKTempTableReuseInTx table : list) {
                if (table.valid()) {
                    table.reuseInTx();
                    return table;
                }
                shareSet.remove(table);
            }
            return null;
        }
    }
}

