/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.service.tx;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.pktemptable.PKTempTableType;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.service.tx.InnerPKTempTableReuseInTx;
import kd.bos.db.pktemptable.service.tx.ReuseInTxGCStrategy;
import kd.bos.db.pktemptable.table.PKTempTableOperator;
import kd.bos.db.pktemptable.utils.DiscardUtil;

public class InnerPKTempTableReuseInTxImpl
implements InnerPKTempTableReuseInTx {
    private final ReuseInTxGCStrategy gcStrategy = ReuseInTxGCStrategy.getInstance();
    private final InnerPKTempTable delegate;
    private final PKTempTableOperator operator;
    private final Map<Integer, Integer> versionMapDataCount = new HashMap<Integer, Integer>();
    private final Set<Integer> closedVersionSet = new HashSet<Integer>();
    private int version = 0;
    private long count = 0L;
    private long inUseCount = 0L;

    public InnerPKTempTableReuseInTxImpl(InnerPKTempTable delegate, PKTempTableOperator operator) {
        this.delegate = delegate;
        this.operator = operator;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public RequestContextInfo getContext() {
        return this.delegate.getContext();
    }

    @Override
    public DBRoute getRoute() {
        return this.delegate.getRoute();
    }

    @Override
    public PKTempTableType getType() {
        return this.delegate.getType();
    }

    @Override
    public void clear(int version) {
        this.deleteByVersionSet(Sets.newHashSet((Object[])new Integer[]{version}), false);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean valid() {
        return this.delegate.valid();
    }

    @Override
    public void onUsing() {
        this.delegate.onUsing();
    }

    @Override
    public void asyncDrop() {
        throw new UnsupportedOperationException("ReuseInTxPKTempTable:" + this.delegate.getName() + " not supported drop.");
    }

    @Override
    public void reuseImmediate() {
        throw new UnsupportedOperationException("ReuseInTxPKTempTable:" + this.delegate.getName() + " not supported reuse.");
    }

    @Override
    public void insert(Collection<?> pks, int version) {
        int pksSize = pks.size();
        this.count += (long)pksSize;
        this.inUseCount += (long)pksSize;
        Integer vdc = this.versionMapDataCount.get(version);
        if (vdc == null) {
            vdc = 0;
        }
        this.versionMapDataCount.put(version, vdc + pksSize);
        this.delegate.insert(pks, version);
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public long inUseDataCount() {
        return this.inUseCount;
    }

    @Override
    public Map<Integer, Integer> getClosedDataVersionMap() {
        HashMap<Integer, Integer> closedVersionMapDataCount = new HashMap<Integer, Integer>(this.closedVersionSet.size());
        for (Integer ver : this.closedVersionSet) {
            closedVersionMapDataCount.put(ver, this.versionMapDataCount.get(ver));
        }
        return closedVersionMapDataCount;
    }

    @Override
    public void close(int version) {
        Integer versionCount;
        if (this.closedVersionSet.add(version) && (versionCount = this.versionMapDataCount.get(version)) != null && versionCount > 0) {
            this.inUseCount -= (long)versionCount.intValue();
        }
    }

    private void deleteByVersionSet(Set<Integer> versionSet, boolean versionHasClosed) {
        int size = this.operator.delete(this.delegate.getRoute(), this, versionSet);
        if (size > 0) {
            this.count -= (long)size;
            for (Integer v : versionSet) {
                this.versionMapDataCount.remove(v);
            }
            if (versionHasClosed) {
                this.closedVersionSet.removeAll(versionSet);
            }
            if (!versionHasClosed) {
                this.inUseCount -= (long)size;
            }
        }
    }

    private void gc() {
        Set<Integer> canDeleteDataVersion = this.gcStrategy.getClearVersionSet(this);
        if (!canDeleteDataVersion.isEmpty()) {
            try {
                this.deleteByVersionSet(canDeleteDataVersion, true);
            }
            catch (Exception ignored) {
                DiscardUtil.discard();
            }
        }
    }

    @Override
    public void reuseInTx() {
        this.gc();
        this.onUsing();
        this.incVersion();
    }

    @Override
    public boolean isReuseInTx() {
        return true;
    }

    private void incVersion() {
        ++this.version;
    }

    public String toString() {
        return "ReuseInTx" + this.delegate.toString();
    }

    @Override
    public void setReuse(boolean reuse) {
        this.delegate.setReuse(reuse);
    }
}

