/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.exception.PKTempTableException;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.table.PKTempTableOperator;
import kd.bos.db.pktemptable.table.ddl.KsqlDDLSqlProvider;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.ksql.shell.KSQLLogOption;
import kd.bos.xdb.QueryTimeout;
import kd.bos.xdb.hint.NoShardingHint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPKTempTableOperator
implements PKTempTableOperator {
    private static final Logger log = LoggerFactory.getLogger(CommonPKTempTableOperator.class);
    protected static final String DROP_TABLE_SQL = CommonPKTempTableOperator.wrapNoShardingSQL("DROP TABLE %s");
    protected static final String TRUNCATE_TABLE_SQL = CommonPKTempTableOperator.wrapNoShardingSQL("TRUNCATE TABLE %s");
    private final KsqlDDLSqlProvider ksqlDDLSqlProvider = new KsqlDDLSqlProvider();

    @Override
    public void create(DBRoute route, InnerPKTempTable table) {
        try {
            TX.__setRouteForceMaster(route.getRouteKey());
            boolean withIndex = PKTempTableConfig.isTempWithIndex();
            boolean withPk = PKTempTableConfig.isTableCreateWithPk();
            int bigStringLength = PKTempTableConfig.getBigStringLength();
            int pkStringLength = PKTempTableConfig.getPkStringLength();
            List<String> sqlList = this.ksqlDDLSqlProvider.getCreateTempTableSql(table, withIndex, withPk, bigStringLength, pkStringLength);
            try (TXHandle ignored = TX.requiresNew("temp_create");){
                for (String sql : sqlList) {
                    DB.execute(route, sql);
                }
            }
        }
        catch (Exception e) {
            log.warn("Create PKTempTable:{} fail,msg: {}", (Object)table.getName(), (Object)e.getMessage());
            throw new PKTempTableException("Create PKTempTable:" + table.getName() + "fail,msg: " + e.getMessage(), e);
        }
    }

    @Override
    public void drop(DBRoute route, InnerPKTempTable table) {
        TX.__setRouteForceMaster(route.getRouteKey());
        try (TXHandle ignored = TX.requiresNew("drop__pk_temp_table");
             QueryTimeout ignored1 = DB.timeout(PKTempTableConfig.getDropTimeoutSecond());
             KSQLLogOption ignored2 = KSQLLogOption.create((boolean)false);){
            DB.execute(route, String.format(DROP_TABLE_SQL, table.getName()));
        }
        catch (Exception ex) {
            log.warn("Drop PKTempTable fail,msg: {}", (Object)ex.getMessage());
            throw new PKTempTableException("Drop UnPoolTempTable fail." + ex.getMessage(), ex);
        }
    }

    @Override
    public void drop(DBRoute route, String name) {
        TX.__setRouteForceMaster(route.getRouteKey());
        try (TXHandle ignored = TX.requiresNew("drop__pk_temp_table");
             QueryTimeout ignored1 = DB.timeout(PKTempTableConfig.getDropTimeoutSecond());
             KSQLLogOption ignored2 = KSQLLogOption.create((boolean)false);){
            DB.execute(route, String.format(DROP_TABLE_SQL, name));
        }
        catch (Exception ex) {
            log.warn("Drop PKTempTable fail,msg: {}", (Object)ex.getMessage());
            throw new PKTempTableException("Drop UnPoolTempTable fail." + ex.getMessage(), ex);
        }
    }

    @Override
    public void truncate(DBRoute route, InnerPKTempTable table) {
        TX.__setRouteForceMaster(route.getRouteKey());
        try (TXHandle ignored = TX.requiresNew("truncate_pk_temp_table");
             QueryTimeout ignored1 = DB.timeout(PKTempTableConfig.getTruncateTimeoutSecond());){
            DB.execute(route, String.format(TRUNCATE_TABLE_SQL, table.getName()));
        }
        catch (Exception ex) {
            log.warn("Truncate PKTempTable fail,msg: {}", (Object)ex.getMessage());
            throw new PKTempTableException("Drop PKTempTable fail." + ex.getMessage(), ex);
        }
    }

    @Override
    public void insert(DBRoute route, InnerPKTempTable table, Collection<?> noNullValueSet, int version) {
        TX.__setRouteForceMaster(route.getRouteKey());
        String tableName = table.getName();
        this.logInsertStack(noNullValueSet.size());
        try (TXHandle ignored = TX.notSupported("temp_insert");
             DelegateConnection con = (DelegateConnection)TX.__getConnectionSkipWriteArchiveCheck(route.getRouteKey(), false);){
            boolean tableWithPK = PKTempTableConfig.isTableCreateWithPk();
            String sizeComment = "/*ids_" + noNullValueSet.size() + "*/";
            String sql = CommonPKTempTableOperator.wrapNoShardingSQL(sizeComment + "INSERT INTO " + tableName + "(FID,FVERSION) VALUES(?,?)");
            if (tableWithPK) {
                sql = CommonPKTempTableOperator.wrapNoShardingSQL(sizeComment + "INSERT INTO " + tableName + "(FID,FPKID,FVERSION) VALUES(?,?,?)");
            }
            CommonPKTempTableOperator.logInsertPKSelfExecuteSQL(sql, con, route);
            try (PreparedStatement ps = con.prepareStatement(sql);){
                int count = 0;
                int batchCount = PKTempTableConfig.getBatchInsertCount();
                DBType dbType = DB.getDBType(route);
                if (batchCount > Short.MAX_VALUE && dbType == DBType.YasDB) {
                    batchCount = Short.MAX_VALUE;
                }
                for (Object v : noNullValueSet) {
                    ps.setObject(1, v);
                    if (tableWithPK) {
                        ps.setLong(2, ID.genLongId());
                    }
                    ps.setInt(tableWithPK ? 3 : 2, version);
                    ps.addBatch();
                    if (++count % batchCount != 0) continue;
                    ps.executeBatch();
                }
                if (count % batchCount != 0) {
                    ps.executeBatch();
                }
            }
        }
        catch (Exception e) {
            log.warn("Insert data in {} fail.msg={}", (Object)tableName, (Object)e.getMessage());
            throw new PKTempTableException("Insert data in temptable fail.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int delete(DBRoute route, InnerPKTempTable table, Set<Integer> deleteVersionList) {
        if (deleteVersionList == null) return 0;
        if (deleteVersionList.isEmpty()) {
            return 0;
        }
        TX.__setRouteForceMaster(route.getRouteKey());
        String tableName = table.getName();
        try (TXHandle ignored1 = TX.notSupported("temp_delete");){
            StringBuilder builder = new StringBuilder("DELETE FROM ");
            builder.append(tableName).append(" WHERE FVERSION IN (");
            ArrayList<String> ins = new ArrayList<String>(deleteVersionList.size());
            for (Integer v : deleteVersionList) {
                ins.add(String.valueOf(v));
            }
            if (ins.size() > 2000) {
                log.warn("PKTempTable delete version is over 2000,what happen.", new Throwable("PKTempTable delete version is over 2000."));
            }
            builder.append(String.join((CharSequence)",", ins));
            builder.append(")");
            int n = DB.update(route, builder.toString());
            return n;
        }
        catch (Exception e) {
            log.warn("Delete data in {} fail.msg={}", (Object)tableName, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public boolean exist(DBRoute route, String tableName) {
        return DB.exitsTable(route, tableName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validTable(DBRoute route, String tableName) {
        try (TXHandle txHandle = TX.requiresNew("valid_tmp_table");){
            DB.query(route, "SELECT TOP 1 1 FROM " + tableName, resultSet -> null);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            if (!PKTempTableConfig.isLogRunTimeException()) return false;
            log.warn("Valid table exist,ignored exception when table not exist;msg={}", (Object)ex.getMessage());
            return false;
        }
    }

    protected static String wrapNoShardingSQL(String sql) {
        return NoShardingHint.genNoShardingSQL((String)sql);
    }

    protected static String wrapDialectNoShardingSQL(String sql) {
        return "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)sql);
    }

    protected static void logInsertPKSelfExecuteSQL(String sql, DelegateConnection con, DBRoute route) {
        con.addWrited(sql);
        if (DB.isSqlOut()) {
            String dbLogTag = DB.isXDBEnable() ? "temp-in-xdb " : "temp-in-db ";
            StringBuilder msg = new StringBuilder(dbLogTag).append("----sql@").append(route.getRouteKey()).append("->").append(con.getRouteKey()).append("#con").append(con.id()).append("----\r\n").append(sql);
            if (log.isInfoEnabled()) {
                log.info(msg.toString());
            }
        }
    }

    protected void logInsertStack(int size) {
        int threshold = PKTempTableConfig.getLogStackThreshold();
        if (threshold > 0 && size >= threshold) {
            Throwable throwable = new Throwable("LogInsertPKTempTablePksStack: " + size);
            log.warn("LogInsertPKTempTablePksStack: {}", (Object)size, (Object)throwable);
        }
    }
}

