/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table;

import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.exception.PKTempTableException;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.table.OraclePKTempTableOperator;
import kd.bos.db.pktemptable.table.ddl.DMDDLSqlProvider;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMPKTempTableOperator
extends OraclePKTempTableOperator {
    private static final Logger log = LoggerFactory.getLogger(DMPKTempTableOperator.class);
    private final DMDDLSqlProvider sqlProvider = new DMDDLSqlProvider();

    @Override
    public void create(DBRoute route, InnerPKTempTable table) {
        try {
            TX.__setRouteForceMaster(route.getRouteKey());
            boolean withIndex = PKTempTableConfig.isTempWithIndex();
            boolean withPk = PKTempTableConfig.isTableCreateWithPk();
            int bigStringLength = PKTempTableConfig.getBigStringLength();
            int pkStringLength = PKTempTableConfig.getPkStringLength();
            List<String> sqlList = this.sqlProvider.getCreateTempTableSql(table, withIndex, withPk, bigStringLength, pkStringLength);
            try (TXHandle ignored = TX.requiresNew("temp_create");){
                for (String sql : sqlList) {
                    DB.execute(route, sql);
                }
            }
        }
        catch (Exception e) {
            log.warn("Create PKTempTable:{} fail,msg: {}", (Object)table.getName(), (Object)e.getMessage());
            throw new PKTempTableException("Create PKTempTable:" + table.getName() + "fail,msg: " + e.getMessage(), e);
        }
    }
}

