/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import java.util.Collection;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.exception.PKTempTableException;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.table.CommonPKTempTableOperator;
import kd.bos.db.pktemptable.table.SQLServerBulkInsert;
import kd.bos.db.pktemptable.table.ddl.SQLServerDDLSqlProvider;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerPKTempTableOperator
extends CommonPKTempTableOperator {
    private static final Logger log = LoggerFactory.getLogger(SQLServerPKTempTableOperator.class);
    private final SQLServerDDLSqlProvider provider = new SQLServerDDLSqlProvider();

    @Override
    public void create(DBRoute route, InnerPKTempTable table) {
        try {
            TX.__setRouteForceMaster(route.getRouteKey());
            boolean withIndex = PKTempTableConfig.isTempWithIndex();
            boolean withPk = PKTempTableConfig.isTableCreateWithPk();
            int bigStringLength = PKTempTableConfig.getBigStringLength();
            int pkStringLength = PKTempTableConfig.getPkStringLength();
            List<String> sqlList = this.provider.getCreateTempTableSql(table, withIndex, withPk, bigStringLength, pkStringLength);
            try (TXHandle ignored = TX.requiresNew("temp_create");){
                for (String sql : sqlList) {
                    DB.execute(route, sql);
                }
            }
        }
        catch (Exception e) {
            log.warn("Create PKTempTable:{} fail,msg: {}", (Object)table.getName(), (Object)e.getMessage());
            throw new PKTempTableException("Create PKTempTable:" + table.getName() + "fail,msg: " + e.getMessage(), e);
        }
    }

    @Override
    public void insert(DBRoute route, InnerPKTempTable table, Collection<?> noNullValueSet, int version) {
        if (!PKTempTableConfig.isSqlServerUseBulk()) {
            super.insert(route, table, noNullValueSet, version);
            return;
        }
        String pkTable = table.getName();
        this.logInsertStack(noNullValueSet.size());
        TX.__setRouteForceMaster(route.getRouteKey());
        try (TXHandle ignored = TX.notSupported("temp_insert");
             DelegateConnection con = (DelegateConnection)TX.__getConnectionSkipWriteArchiveCheck(route.getRouteKey(), false);){
            SQLServerPKTempTableOperator.logInsertPKSelfExecuteSQL("BULK INSERT " + pkTable + " ids_" + noNullValueSet.size(), con, route);
            new SQLServerBulkInsert(con.unwrap(SQLServerConnection.class), table, noNullValueSet, version).insert();
        }
        catch (Exception ex) {
            log.warn("SQLServer use bulk Insert data in {} fail,will use batch insert.msg={}", (Object)pkTable, (Object)ex.getMessage());
            PKTempTableConfig.setSqlServerUseBulk(false);
            super.insert(route, table, noNullValueSet, version);
        }
    }
}

