/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table;

import com.tencentcloud.tdsql.mysql.cj.jdbc.JdbcStatement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Statement;
import java.util.Collection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.exception.PKTempTableException;
import kd.bos.db.pktemptable.service.InnerPKTempTable;
import kd.bos.db.pktemptable.table.CommonPKTempTableOperator;
import kd.bos.db.pktemptable.table.ddl.TDSQLDialectDDLSqlProvider;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDSQLPKTempTableOperator
extends CommonPKTempTableOperator {
    private static final Logger log = LoggerFactory.getLogger(TDSQLPKTempTableOperator.class);
    private final TDSQLDialectDDLSqlProvider provider = new TDSQLDialectDDLSqlProvider();

    @Override
    public void create(DBRoute route, InnerPKTempTable table) {
        try {
            TX.__setRouteForceMaster(route.getRouteKey());
            String sql = this.provider.getCreateTempTableSql(table, new TDSQLDialectDDLSqlProvider.CreateTableOption());
            try (TXHandle ignored = TX.requiresNew("temp_create");){
                DB.execute(route, sql);
            }
        }
        catch (Exception e) {
            log.warn("Create PKTempTable:{} fail,msg: {}", (Object)table.getName(), (Object)e.getMessage());
            throw new PKTempTableException("Create PKTempTable:" + table.getName() + "fail,msg: " + e.getMessage(), e);
        }
    }

    @Override
    public void insert(DBRoute route, InnerPKTempTable table, Collection<?> noNullValueSet, int version) {
        String pkTable = table.getName();
        if (!PKTempTableConfig.isMysqlUseLoadInfile()) {
            super.insert(route, table, noNullValueSet, version);
            return;
        }
        this.logInsertStack(noNullValueSet.size());
        TX.__setRouteForceMaster(route.getRouteKey());
        try (TXHandle ignored = TX.notSupported("temp_insert");
             DelegateConnection con = (DelegateConnection)TX.__getConnectionSkipWriteArchiveCheck(route.getRouteKey(), false);){
            boolean tableWithPk = PKTempTableConfig.isTableCreateWithPk();
            String sql = TDSQLPKTempTableOperator.wrapDialectNoShardingSQL("LOAD DATA LOCAL INFILE 'ids_" + noNullValueSet.size() + "' IGNORE INTO TABLE " + pkTable + "(FID,FVERSION)");
            if (tableWithPk) {
                sql = TDSQLPKTempTableOperator.wrapDialectNoShardingSQL("/*with_pk*/LOAD DATA LOCAL INFILE 'ids_" + noNullValueSet.size() + "' IGNORE INTO TABLE " + pkTable + "(FID,FPKID,FVERSION)");
            }
            TDSQLPKTempTableOperator.logInsertPKSelfExecuteSQL(sql, con, route);
            StringBuilder sb = new StringBuilder(noNullValueSet.size() * 19);
            for (Object value : noNullValueSet) {
                sb.append(value);
                if (tableWithPk) {
                    sb.append('\t').append(ID.genLongId());
                }
                sb.append('\t').append(version);
                sb.append('\n');
            }
            sb.setLength(sb.length() - 1);
            try (Statement stmt = con.createStatement();){
                ByteArrayInputStream bis = new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
                JdbcStatement js = stmt.unwrap(JdbcStatement.class);
                js.setLocalInfileInputStream((InputStream)bis);
                stmt.execute(sql);
            }
        }
        catch (Exception ex) {
            log.warn("TDSQL use load data infile {} fail,will use batch insert . fail msg={}", (Object)pkTable, (Object)ex.getMessage());
            PKTempTableConfig.setMysqlUseLoadInfile(false);
            super.insert(route, table, noNullValueSet, version);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validTable(DBRoute route, String tableName) {
        try (TXHandle txHandle = TX.requiresNew("valid_tmp_table");){
            DB.query(route, TDSQLPKTempTableOperator.wrapDialectNoShardingSQL("SELECT 1 FROM " + tableName + " LIMIT 1"), resultSet -> null);
            boolean bl = true;
            return bl;
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

