/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.table.ddl;

import kd.bos.db.pktemptable.PKTempTableType;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.pktemptable.service.InnerPKTempTable;

public class TiDBDialectDDLSqlProvider {
    public String getCreateTempTableSql(InnerPKTempTable table, CreateTableOption option) {
        String tableName = table.getName();
        int bigStringLength = option.bigStringLength;
        StringBuilder builder = new StringBuilder("/*dialect*//*NO_SHARDING*/CREATE TABLE ");
        builder.append(tableName);
        builder.append("(");
        builder.append("FID ");
        switch (table.getType()) {
            case STRING: {
                builder.append(String.format("VARCHAR(%d) DEFAULT NULL,", option.pkStringLength));
                break;
            }
            case LONG: {
                builder.append("BIGINT DEFAULT NULL,");
                break;
            }
            case BIG_STRING: {
                if (option.bigStringLength <= 0) {
                    bigStringLength = 80;
                }
                builder.append("VARCHAR(").append(bigStringLength).append(")DEFAULT NULL,");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown temp table type.");
            }
        }
        if (option.withPK) {
            builder.append("FPKID BIGINT NOT NULL,");
        }
        builder.append("FVERSION INT NOT NULL,");
        if (option.withPK) {
            builder.append("PRIMARY KEY (FPKID),");
        }
        if (option.withIndex) {
            builder.append("KEY IDX_").append(tableName).append("_FID").append(" (FID),");
        }
        builder.append("KEY IDX_").append(tableName).append("_FVERSION").append(" (FVERSION) USING BTREE)");
        if (table.getType() != PKTempTableType.LONG && !option.useDBCharset) {
            String tpl = " DEFAULT CHARSET=%s COLLATE=%s";
            builder.append(String.format(tpl, option.tableCharset, option.tableCollate));
        }
        return builder.toString();
    }

    public String getCreateMetaTableSql() {
        return "CREATE TABLE `t_pktemp_meta` ( `ftable_name` varchar(50) NOT NULL, `fcreate_time` datetime DEFAULT NULL, PRIMARY KEY (`ftable_name`),KEY `IDX_PKTEMP_META_FCREATE_TIME` (`fcreate_time`))";
    }

    public static class CreateTableOption {
        private final boolean withIndex;
        private final boolean withPK;
        private final int bigStringLength;
        private final int pkStringLength;
        private final boolean useDBCharset;
        private final String tableCharset;
        private final String tableCollate;

        public CreateTableOption() {
            this.withIndex = PKTempTableConfig.isTempWithIndex();
            this.withPK = PKTempTableConfig.isTableCreateWithPk();
            this.bigStringLength = PKTempTableConfig.getBigStringLength();
            this.useDBCharset = PKTempTableConfig.isMysqlUseDbDefaultCharset();
            this.tableCharset = PKTempTableConfig.getMysqlTableCharset();
            this.tableCollate = PKTempTableConfig.getMysqlTableCollate();
            this.pkStringLength = PKTempTableConfig.getPkStringLength();
        }

        public CreateTableOption(boolean withIndex, boolean withPK, int bigStringLength, boolean useDBCharset, String tableCharset, String tableCollate, int pkStringLength) {
            this.withIndex = withIndex;
            this.withPK = withPK;
            this.bigStringLength = bigStringLength;
            this.useDBCharset = useDBCharset;
            this.tableCharset = tableCharset;
            this.tableCollate = tableCollate;
            this.pkStringLength = pkStringLength;
        }
    }
}

