/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.db.pktemptable.service.PKTempTableRequestContextRunnable;

public class ExecutorServiceUtil {
    private ExecutorServiceUtil() {
    }

    public static ExecutorService newFixExecutorService(int threadSize, final String threadName) {
        return Executors.newFixedThreadPool(threadSize, new ThreadFactory(){
            private AtomicInteger i = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                r = new PKTempTableRequestContextRunnable(r);
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName(threadName + "Thread-" + this.i.incrementAndGet());
                return t;
            }
        });
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String threadName) {
        return Executors.newSingleThreadScheduledExecutor((Runnable r) -> {
            PKTempTableRequestContextRunnable runnable = new PKTempTableRequestContextRunnable(r);
            Thread mainThread = new Thread(runnable);
            mainThread.setDaemon(true);
            mainThread.setName(threadName);
            return mainThread;
        });
    }
}

