/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.pktemptable.utils;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.xdb.hint.NoShardingHint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PKTempTableMetaUtils {
    private static final Logger log = LoggerFactory.getLogger(PKTempTableMetaUtils.class);
    private static final String CREATE_META_TABLE_LOCK_KEY = "/db/pktemptable/init_meta_table/";
    private static final String CREATE_META_TABLE_SQL = PKTempTableMetaUtils.wrapNoShardingSQL("CREATE TABLE T_PKTEMP_META(ftable_name varchar(50) not null, fcreate_time datetime not null)");
    private static final String CREATE_META_TABLE_NAME_INDEX_SQL = PKTempTableMetaUtils.wrapNoShardingSQL("CREATE UNIQUE INDEX IX_T_PKTEMP_META_FTABLE_NAME ON T_PKTEMP_META(ftable_name)");
    private static final String CREATE_META_TABLE_CREATE_TIME_INDEX_SQL = PKTempTableMetaUtils.wrapNoShardingSQL("CREATE INDEX IX_T_PKTEMP_META_FCREATE_TIME ON T_PKTEMP_META(fcreate_time)");
    private static final String CREATE_META_TABLE_PK_SQL = PKTempTableMetaUtils.wrapNoShardingSQL("EXEC P_ALTERPK 'PK_PKTEMP_META', 'T_PKTEMP_META', 'ftable_name', '1'");
    private static final String TABLE_NAME_IDX_KEY = "IX_T_PKTEMP_META_FTABLE_NAME";

    private PKTempTableMetaUtils() {
    }

    public static void initMetaTable(DBRoute route, RequestContextInfo rc) {
        TX.__setRouteForceMaster(route.getRouteKey());
        DBType dbType = DB.getDBType(route);
        if (dbType == DBType.ClickHouse) {
            if (!DB.exitsTableForManager(route, "T_PKTEMP_META")) {
                String CLICKHOUSE_CREATE_META_TABLE_SQL = PKTempTableMetaUtils.wrapDialectNoShardingSQL("CREATE TABLE t_pktemp_meta(ftable_name FixedString(50) DEFAULT ' ', fcreate_time datetime DEFAULT '1970-01-01 00:00:00') ENGINE=MergeTree() order by(ftable_name, fcreate_time)");
                PKTempTableMetaUtils.executeIgnoredException(route, CLICKHOUSE_CREATE_META_TABLE_SQL);
            }
        } else {
            try (TXHandle ignored = TX.requiresNew("check_pk_temp_table_meta");){
                if (DB.exitsTable(route, "T_PKTEMP_META")) {
                    List<String> primaryKeys = DB.getPrimaryKeys(route, "T_PKTEMP_META");
                    if (primaryKeys.isEmpty()) {
                        PKTempTableMetaUtils.createMetaTable(route, CREATE_META_TABLE_PK_SQL);
                    }
                    if (PKTempTableMetaUtils.idxExist(route, TABLE_NAME_IDX_KEY)) {
                        PKTempTableMetaUtils.delTableNameIdx(route);
                    }
                    return;
                }
            }
            try {
                ignored = TX.requiresNew("crate_pk_temp_table_meta");
                var4_6 = null;
                try {
                    PKTempTableMetaUtils.executeIgnoredException(route, CREATE_META_TABLE_SQL);
                    PKTempTableMetaUtils.executeIgnoredException(route, CREATE_META_TABLE_CREATE_TIME_INDEX_SQL);
                    PKTempTableMetaUtils.executeIgnoredException(route, CREATE_META_TABLE_PK_SQL);
                }
                catch (Throwable throwable) {
                    var4_6 = throwable;
                    throw throwable;
                }
                finally {
                    if (ignored != null) {
                        if (var4_6 != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable) {
                                var4_6.addSuppressed(throwable);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.warn("Create MetaTable:{} fail,msg: {},rc:{}", new Object[]{"T_PKTEMP_META", ex.getMessage(), rc});
            }
        }
    }

    private static boolean idxExist(DBRoute route, String idxName) {
        String sql = "SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s'";
        sql = String.format(sql, idxName);
        return DB.query(route, sql, ResultSet::next);
    }

    private static void delTableNameIdx(DBRoute route) {
        String sql = "EXEC p_DropIdx 'IX_T_PKTEMP_META_FTABLE_NAME', 'T_PKTEMP_META'";
        PKTempTableMetaUtils.executeIgnoredException(route, sql);
    }

    private static void executeIgnoredException(DBRoute route, String sql) {
        try {
            DB.execute(route, sql);
        }
        catch (Exception ex) {
            log.warn("PKTempTableMetaSqlExecute fail,msg={}", (Object)ex.getMessage());
        }
    }

    private static void createMetaTable(DBRoute route, String sql) {
        try {
            DB.execute(route, sql);
        }
        catch (Exception ex) {
            log.warn("PKTempTableMetaCreateError,msg={}", (Object)ex.getMessage());
        }
    }

    public static void insert(DBRoute route, String name, LocalDateTime createTime) {
        try (TXHandle ignored = TX.notSupported();){
            DB.execute(route, PKTempTableMetaUtils.wrapNoShardingSQL("INSERT INTO T_PKTEMP_META (ftable_name,fcreate_time) VALUES (?,?)"), new Object[]{name, Timestamp.from(createTime.atZone(ZoneId.systemDefault()).toInstant())});
        }
    }

    public static void delete(DBRoute route, String name) {
        try (TXHandle ignored = TX.notSupported();){
            DB.execute(route, PKTempTableMetaUtils.wrapNoShardingSQL("DELETE FROM T_PKTEMP_META WHERE ftable_name=?"), new Object[]{name});
        }
    }

    public static void delete(DBRoute route, List<String> names) {
        int batchSize = 1000;
        int index = 0;
        int size = names.size();
        while (index < size) {
            int next = Math.min(size, index + batchSize);
            List<String> batch = names.subList(index, next);
            try (TXHandle ignored = TX.notSupported();){
                StringBuilder sb = new StringBuilder("DELETE FROM T_PKTEMP_META WHERE ftable_name in (");
                for (int i = 0; i < batch.size(); ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("'").append(batch.get(i)).append("'");
                }
                sb.append(")");
                DB.execute(route, PKTempTableMetaUtils.wrapNoShardingSQL(sb.toString()));
            }
            index = next;
        }
    }

    public static List<String> queryTimeoutList(DBRoute route, int top) {
        int timeoutMinute = PKTempTableConfig.getTableClearTimeoutMinute();
        LocalDateTime timeout = LocalDateTime.now().plusMinutes(Math.abs(timeoutMinute) * -1);
        String sql = PKTempTableMetaUtils.wrapNoShardingSQL("SELECT TOP " + top + " ftable_name FROM T_PKTEMP_META WHERE fcreate_time <= ? order by fcreate_time");
        try (TXHandle ignored = TX.requiresNew();){
            List list = DB.query(route, sql, new Object[]{Timestamp.from(timeout.atZone(ZoneId.systemDefault()).toInstant())}, rs -> {
                ArrayList<String> result = new ArrayList<String>(500);
                while (rs.next()) {
                    result.add(rs.getString("ftable_name"));
                }
                return result;
            });
            return list;
        }
    }

    public static String wrapNoShardingSQL(String sql) {
        return NoShardingHint.genNoShardingSQL((String)sql);
    }

    public static String wrapDialectNoShardingSQL(String sql) {
        return "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)sql);
    }
}

