/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.privacy;

import kd.bos.db.privacy.IPrivacyDataPermissionService;
import kd.bos.db.privacy.IPrivacyDataQueryService;
import kd.bos.db.privacy.IPrivacyDataStoreService;
import kd.bos.db.privacy.IPrivacyEncryptService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PrivacyDataCenterManager {
    private static final Log log = LogFactory.getLog((String)"PrivacyDataCenterManager");
    private static IPrivacyDataQueryService queryService = null;
    private static IPrivacyEncryptService encryptService = null;
    private static IPrivacyDataStoreService storeService = null;
    private static IPrivacyDataPermissionService permissionService = null;
    private static final String PRIVACYCENTER_ENABLE = "privacycenter.enable";
    private static final String TRUE = "true";

    public static IPrivacyDataQueryService getQueryService() {
        return queryService;
    }

    public static IPrivacyEncryptService getEncryptService() {
        return encryptService;
    }

    public static IPrivacyDataStoreService getStoreService() {
        return storeService;
    }

    public static IPrivacyDataPermissionService getPermissionService() {
        return permissionService;
    }

    public static boolean isEnable() {
        if (permissionService == null) {
            return false;
        }
        if (permissionService.isPrivacyEnable()) {
            return queryService != null && encryptService != null && storeService != null;
        }
        return false;
    }

    public static void clearCache() {
        encryptService.clearCache();
        permissionService.clearCache();
    }

    static {
        try {
            queryService = (IPrivacyDataQueryService)Class.forName("kd.bos.privacy.service.PrivacyDataQueryService").newInstance();
            encryptService = (IPrivacyEncryptService)Class.forName("kd.bos.privacy.service.PrivacyEncryptService").newInstance();
            storeService = (IPrivacyDataStoreService)Class.forName("kd.bos.privacy.service.PrivacyDataStoreService").newInstance();
            permissionService = (IPrivacyDataPermissionService)Class.forName("kd.bos.privacy.service.PrivacyDataPermissionService").newInstance();
        }
        catch (Throwable e) {
            log.error("PrivacyDataCenterService init", e);
            queryService = null;
            encryptService = null;
            storeService = null;
            permissionService = null;
        }
    }
}

