/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.sharding;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.bundle.Resources;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.sharding.ShardConfigLoader;
import kd.bos.db.sharding.TentantAccountAble;
import kd.bos.db.sharding.tablerw.DBAnyRWContext;
import kd.bos.db.sharding.tablerw.DBTableRWNotifier;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.XDBErrorCode;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.transaction.XDBTransactionHook;

public class DBShardingRuntime
implements TentantAccountAble {
    private static final Log log = LogFactory.getLog(DBShardingRuntime.class);
    private static final Map<String, DBShardingRuntime> instanceMap = new ConcurrentHashMap<String, DBShardingRuntime>();
    private static final ShardConfigLoader shardingConfigLoader;
    private static final String XDB_RW_WAIT = "xdb.rw.wait";
    private static int waitRWseconds;
    private static final String allTableKey = "*";
    private final String accountId;
    private final String tenantId;
    private final Map<String, RW> rwMap = new ConcurrentHashMap<String, RW>();
    private final AtomicBoolean configLoaded = new AtomicBoolean();
    private final Object configLoadLock = new Object();
    private final AtomicReference<Thread> configLoadThread = new AtomicReference();
    private final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    public static ShardConfigLoader getShardingConfigLoader() {
        return shardingConfigLoader;
    }

    public static DBShardingRuntime get() {
        RequestContextInfo rci = RequestContextInfo.get();
        String accountId = rci.getAccountId();
        if (accountId == null) {
            throw new KDException(BosErrorCode.nullError, Resources.get((String)"bos-dbengine", (String)"DBShardingRuntime_5", (String)"\u5f53\u524d\u7ebf\u7a0b\u6ca1\u6709\u8bbe\u7f6e\u7528\u6237\u4e0a\u4e0b\u6587\uff0c\u8bf7\u68c0\u67e5\u5e76\u8bbe\u7f6e\u7ebf\u7a0b\u7528\u6237\u4e0a\u4e0b\u6587\u3002", (Object[])new Object[0]), new Exception().getCause());
        }
        return instanceMap.computeIfAbsent(accountId, key -> new DBShardingRuntime((String)key, rci.getTenantId()));
    }

    public static DBShardingRuntime get(String tendantId, String accountId) {
        return instanceMap.computeIfAbsent(accountId, key -> new DBShardingRuntime((String)key, tendantId));
    }

    private DBShardingRuntime(String accountId, String tenantId) {
        this.accountId = accountId;
        this.tenantId = tenantId;
        if (!XDBTransactionHook.isInited()) {
            XDBTransactionHook.init(() -> {
                TXContext tx = TX.__getTXContext();
                if (tx != null) {
                    return tx.__peekTMRoot().id();
                }
                return -1L;
            });
        }
    }

    public AtomicBoolean getConfigLoaded() {
        return this.configLoaded;
    }

    AtomicReference<Thread> getConfigLoadThread() {
        return this.configLoadThread;
    }

    Object getConfigLoadLock() {
        return this.configLoadLock;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public DBAnyRWContext setupThreadDBAnyRWContext() {
        return DBAnyRWContext.create();
    }

    private boolean currentThreadIsDBAnyRW() {
        return DBAnyRWContext.get() != null;
    }

    public void setAllTableRWAtCurrentNode(boolean r, boolean w) {
        this.rwMap.put(allTableKey, RW.of(r, w));
        log.info("setAllTableRW r=" + r + ", w=" + w);
    }

    public String fireLimitTableRW(String tableName, boolean rw) {
        String ts = this.doSetTableRWAtCurrentNode(rw, rw, tableName);
        String value = DBTableRWNotifier.doFireLimitTableRW(ts, rw, rw);
        RequestContextInfo rc = RequestContextInfo.get();
        String cacheKey = DBTableRWNotifier.getObserveCachkey(rc.getTenantId(), rc.getAccountId(), Instance.getInstanceId(), tableName);
        this.cache.put(cacheKey, (Object)value, 2, TimeUnit.DAYS);
        log.info("fireLimitTableRW,cacheKey: " + cacheKey + ", cacheValue: " + value);
        return value;
    }

    public void setTableRWAtCurrentNode(boolean r, boolean w, String tableName) {
        this.doSetTableRWAtCurrentNode(r, w, tableName);
    }

    private String doSetTableRWAtCurrentNode(boolean r, boolean w, String tableName) {
        RW rw = RW.of(r, w);
        StringBuilder ts = new StringBuilder();
        this.rwMap.put(tableName.toLowerCase(), rw);
        ts.append(tableName.toLowerCase());
        return ts.toString();
    }

    public boolean candReadTable(String ... tableNames) {
        if (this.rwMap.isEmpty()) {
            return true;
        }
        RW allRW = this.rwMap.get(allTableKey);
        if (allRW != null && allRW != RW.r1_w0 && allRW != RW.r1_w1) {
            return false;
        }
        if (tableNames != null) {
            for (String tableName : tableNames) {
                RW rw = this.rwMap.get(this.getOriginalTableName(tableName).toLowerCase());
                if (rw == null || rw == RW.r1_w0 || rw == RW.r1_w1) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canWriteTable(String ... tableNames) {
        if (this.rwMap.isEmpty()) {
            return true;
        }
        RW allRW = this.rwMap.get(allTableKey);
        if (allRW != null && allRW != RW.r1_w1 && allRW != RW.r0_w1) {
            return false;
        }
        if (tableNames != null) {
            for (String tableName : tableNames) {
                RW rw = this.rwMap.get(this.getOriginalTableName(tableName).toLowerCase());
                if (rw == null || rw == RW.r1_w1 || rw == RW.r0_w1) continue;
                return false;
            }
        }
        return true;
    }

    private String getOriginalTableName(String name) {
        int p = name.lastIndexOf(36);
        if (p != -1) {
            return name.substring(0, p);
        }
        return name;
    }

    public void clearTableRW() {
        this.rwMap.clear();
    }

    public void waitForReadable(String ... tableNames) {
        this.waitForRW(true, tableNames);
    }

    public void waitForWriteable(String ... tableNames) {
        this.waitForRW(false, tableNames);
    }

    private void waitForRW(boolean read, String ... tableNames) {
        if (this.currentThreadIsDBAnyRW()) {
            return;
        }
        long maxTS = waitRWseconds * 1000;
        long ts = System.currentTimeMillis();
        int round = 0;
        while (true) {
            if (read ? this.candReadTable(tableNames) : this.canWriteTable(tableNames)) {
                return;
            }
            if (System.currentTimeMillis() - ts > maxTS) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (++round % 10 != 0) continue;
            String msg = Thread.currentThread() + Resources.get((String)"bos-dbengine", (String)"DBShardingRuntime_0", (String)"\u7b49\u5f85\u8868\u53ef\u8bfb\u5199(round=", (Object[])new Object[0]) + round + "):" + Arrays.toString(tableNames);
            if (!log.isInfoEnabled()) continue;
            log.info(msg);
        }
        throw new KDException(XDBErrorCode.xdbSqlRWTimeOut, new Object[]{Resources.get((String)"bos-dbengine", (String)"DBShardingRuntime_1", (String)"\u8868\u7b49\u5f85\u53ef", (Object[])new Object[0]) + (read ? Resources.get((String)"bos-dbengine", (String)"DBShardingRuntime_2", (String)"\u8bfb", (Object[])new Object[0]) : Resources.get((String)"bos-dbengine", (String)"DBShardingRuntime_3", (String)"\u5199", (Object[])new Object[0])) + Resources.get((String)"bos-dbengine", (String)"DBShardingRuntime_4", (String)"\u8d85\u65f6(>", (Object[])new Object[0]) + waitRWseconds + "s): " + Arrays.toString(tableNames) + " @" + this + ", rwMap=" + this.rwMap});
    }

    public String toString() {
        return "tenantId=" + this.tenantId + ", accountId=" + this.accountId + ", configLoaded=" + this.configLoaded.get() + ", configLoadThread=" + this.configLoadThread.get();
    }

    static {
        waitRWseconds = 30;
        try {
            shardingConfigLoader = (ShardConfigLoader)Class.forName("kd.bos.xdb.repository.impl.ShardConfigLoaderImpl").newInstance();
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
        ConfigurationUtil.observeInteger((String)XDB_RW_WAIT, (int)waitRWseconds, v -> {
            waitRWseconds = v;
        });
        DBTableRWNotifier.registTableRWListener(ti -> {
            log.info("[DBTableRWListener] onReceiveChangeTableRW " + ti);
            try (AutoCloseable ac = new RequestContextInfo(ti.getTenantId(), ti.getAccountId()).setupThreadRequestContext();){
                DBShardingRuntime.get().setTableRWAtCurrentNode(ti.isReadable(), ti.isWritable(), ti.getTableName());
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
        });
    }

    private static enum RW {
        r0_w0,
        r0_w1,
        r1_w0,
        r1_w1;


        static RW of(boolean r, boolean w) {
            if (r) {
                return w ? r1_w1 : r1_w0;
            }
            return w ? r0_w1 : r0_w0;
        }
    }
}

