/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.sharding;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.sharding.taskpaused.ShardTaskPausedNotifier;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.exception.ExceptionUtil;

public class ShardTaskRuntime {
    private static final Log log = LogFactory.getLog(ShardTaskRuntime.class);
    private static final Map<String, ShardTaskRuntime> instanceMap = new ConcurrentHashMap<String, ShardTaskRuntime>();
    private final String accountId;
    private final String tenantId;
    private volatile Map<String, Boolean> pausedMap = new ConcurrentHashMap<String, Boolean>();
    private volatile Map<String, Boolean> interruptedMap = new ConcurrentHashMap<String, Boolean>();

    public static ShardTaskRuntime get() {
        RequestContextInfo rci = RequestContextInfo.get();
        String accountId = rci.getAccountId();
        return instanceMap.computeIfAbsent(accountId, key -> new ShardTaskRuntime((String)key, rci.getTenantId()));
    }

    private ShardTaskRuntime(String accountId, String tenantId) {
        this.accountId = accountId;
        this.tenantId = tenantId;
    }

    private String getOriginalTableName(String name) {
        int p = name.lastIndexOf(36);
        if (p != -1) {
            return name.substring(0, p);
        }
        return name;
    }

    public void fireLimitTaskPaused(boolean paused, String tableName) {
        this.setTaskPausedCurrentNode(paused, tableName);
        ShardTaskPausedNotifier.fireLimitTaskPaused(tableName.toLowerCase(), paused);
    }

    public String setTaskPausedCurrentNode(boolean paused, String tableName) {
        this.pausedMap.put(tableName.toLowerCase(), paused);
        log.info("setTablePaused " + tableName + " paused=" + paused);
        return tableName;
    }

    public String setTaskInterruptedCurrentNode(boolean interrupted, String tableName) {
        this.interruptedMap.put(tableName.toLowerCase(), interrupted);
        log.info("setTaskInterruptedCurrentNode " + tableName + " interrupted=" + interrupted);
        return tableName;
    }

    public boolean isTaskPaused(String tableName) {
        if (this.pausedMap.isEmpty()) {
            return false;
        }
        if (tableName != null) {
            Boolean isPaused = this.pausedMap.get(this.getOriginalTableName(tableName).toLowerCase());
            return null == isPaused ? false : isPaused;
        }
        return false;
    }

    public boolean isTaskInterrupted(String tableName) {
        if (this.interruptedMap.isEmpty()) {
            return false;
        }
        if (tableName != null) {
            Boolean isInterrupted = this.interruptedMap.get(this.getOriginalTableName(tableName).toLowerCase());
            return null == isInterrupted ? false : isInterrupted;
        }
        return false;
    }

    public String toString() {
        return "tenantId=" + this.tenantId + ", accountId=" + this.accountId;
    }

    static {
        ShardTaskPausedNotifier.registTaskPausedListener(ti -> {
            try (AutoCloseable ac = new RequestContextInfo(ti.getTenantId(), ti.getAccountId()).setupThreadRequestContext();){
                ShardTaskRuntime.get().setTaskPausedCurrentNode(ti.isPaused(), ti.getTableName());
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
        });
    }
}

