/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.sharding.configchanged;

import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.db.sharding.configchanged.DBShardingConfigInfo;
import kd.bos.db.sharding.configchanged.DBShardingConfigListener;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.xdb.exception.ExceptionUtil;

public class DBShardingConfigNotifier
extends ZKWatchValueNotifier {
    private static final String XDB_SHARDING_ENTITY_CONFIG_WATCHER = "xdb.sharding.entity.config.watcher";
    private static final String FIRE_RELOAD_ENTITY_CONFIG_LOCK_KEY = "/xdbsharding/fire_reload_entity_config";

    public static void registReloadShardingConfigListener(final DBShardingConfigListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    DBShardingConfigInfo si = DBShardingConfigListener.fromKey((String)newValue);
                    l.onReceiveReloadShardingConfig(si);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        DBShardingConfigNotifier.observeChange(XDB_SHARDING_ENTITY_CONFIG_WATCHER, listener);
    }

    public static void fireReloadShardingConfig(String entityName) {
        String value = DBShardingConfigListener.currentKey(entityName);
        log.info("fireReloadShardingConfig " + entityName + " " + value);
        DBShardingConfigNotifier.fireLimit(FIRE_RELOAD_ENTITY_CONFIG_LOCK_KEY, XDB_SHARDING_ENTITY_CONFIG_WATCHER, value);
    }
}

