/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.sharding.tablecache;

import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.db.sharding.tablecache.ChangeTableCacheInfo;
import kd.bos.db.sharding.tablecache.ChangeTableCacheListener;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.endpoint.EndPointValueChangeService;
import kd.bos.xdb.exception.ExceptionUtil;

public class ChangeTableCacheNotifier
extends ZKWatchValueNotifier {
    private static final String XDB_SHARDING_TABLE_CACHE_WATCHER = "xdb.sharding.tablecache.watcher";
    private static final String FIRE_CHANGE_TABLE_CACHE_LOCK_KEY = "/xdbsharding/fire_change_table_cache";

    public static void registChangeTableCacheListener(final ChangeTableCacheListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    ChangeTableCacheInfo si = ChangeTableCacheListener.fromKey((String)newValue);
                    l.onReceiveChangeTableCache(si);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        if (excludeZk) {
            EndPointValueChangeService.observeChange((String)XDB_SHARDING_TABLE_CACHE_WATCHER, (ConfigurationChangeListener)listener);
        } else {
            ConfigurationUtil.observeChange((String)XDB_SHARDING_TABLE_CACHE_WATCHER, (ConfigurationChangeListener)listener);
        }
    }

    public static void fireAddTable2Cache(String tableName) {
        String value = ChangeTableCacheListener.currentKey(tableName);
        log.info("fireAddTable2Cache " + tableName + " " + value);
        ChangeTableCacheNotifier.fireLimit(FIRE_CHANGE_TABLE_CACHE_LOCK_KEY, XDB_SHARDING_TABLE_CACHE_WATCHER, value);
    }
}

