/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.sharding.tablerw;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.db.sharding.tablerw.DBTableRWInfo;
import kd.bos.db.sharding.tablerw.DBTableRWListener;
import kd.bos.db.sharding.tablerw.ZKWatichConfirmNotifier;
import kd.bos.instance.Instance;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.exception.ExceptionUtil;

public class DBTableRWNotifier
extends ZKWatchValueNotifier {
    private static final String XDB_SHARDING_TABLE_RW_WATCHER = "xdb.sharding.table.rw.watcher";
    private static final String FIRE_TABLE_RW_LOCK_KEY = "/xdbsharding/fire_table_rw";
    public static final String TABLE_RW_LOCK_CACHE_KEY = "xdb_table_rw";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    public static void registTableRWListener(final DBTableRWListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    DBTableRWInfo ti = DBTableRWListener.fromKey((String)newValue);
                    l.onReceiveChangeTableRW(ti);
                    String cacheKey = DBTableRWNotifier.getObserveCachkey(ti.getTenantId(), ti.getAccountId(), Instance.getInstanceId(), ti.getTableName());
                    cache.put(cacheKey, (Object)((String)newValue), 2, TimeUnit.DAYS);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        DBTableRWNotifier.observeChange(XDB_SHARDING_TABLE_RW_WATCHER, listener);
    }

    public static String doFireLimitTableRW(String tableNames, boolean r, boolean w) {
        String value = DBTableRWListener.currentKey(tableNames, r, w);
        log.info("doFireLimitTableRW " + tableNames + " " + value);
        DBTableRWNotifier.fireLimit(FIRE_TABLE_RW_LOCK_KEY, XDB_SHARDING_TABLE_RW_WATCHER, value);
        return value;
    }

    public static ZKWatichConfirmNotifier confirmNotifierTableRW(String entitynumber, String tableName, String value) {
        Set<String> allNodes = DBTableRWNotifier.getAllNodes();
        if (XDBConfig.get().isDevMode()) {
            return new ZKWatichConfirmNotifier(true, allNodes, new HashSet<String>());
        }
        return DBTableRWNotifier.confirmNotify(entitynumber, tableName, value, allNodes);
    }

    private static ZKWatichConfirmNotifier confirmNotify(String entitynumber, String tableName, String value, Set<String> otherNodes) {
        HashSet<String> hasNotifier = new HashSet<String>();
        HashSet<String> tobeNotifier = new HashSet<String>();
        boolean confirmAll = true;
        RequestContextInfo rc = RequestContextInfo.get();
        for (int i = 0; i < 3; ++i) {
            confirmAll = true;
            tobeNotifier = new HashSet();
            for (String item : otherNodes) {
                String cacheKey = DBTableRWNotifier.getObserveCachkey(rc.getTenantId(), rc.getAccountId(), item, tableName);
                String cacheValue = (String)cache.get(cacheKey);
                if (value.equals(cacheValue)) {
                    hasNotifier.add(item);
                } else {
                    cacheKey = DBTableRWNotifier.getObserveCachkey(rc.getTenantId(), rc.getAccountId(), item, entitynumber);
                    cacheValue = (String)cache.get(cacheKey);
                    if (value.equals(cacheValue)) {
                        hasNotifier.add(item);
                    } else {
                        tobeNotifier.add(item);
                        confirmAll = false;
                    }
                }
                log.info("confirmNotify,cacheKey: " + cacheKey + ", cacheValue: " + cacheValue);
            }
            if (confirmAll) break;
            otherNodes = tobeNotifier;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
        }
        return new ZKWatichConfirmNotifier(confirmAll, hasNotifier, tobeNotifier);
    }

    public static String getObserveCachkey(String tenantId, String accountId, String instanceId, String tableName) {
        return tenantId + "#" + accountId + "#" + TABLE_RW_LOCK_CACHE_KEY + "#" + instanceId + "#" + tableName.toLowerCase();
    }
}

