/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.sharding.taskpaused;

import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.db.sharding.taskpaused.ShardTaskPausedInfo;
import kd.bos.db.sharding.taskpaused.ShardTaskPausedListener;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.xdb.exception.ExceptionUtil;

public class ShardTaskPausedNotifier
extends ZKWatchValueNotifier {
    private static final String XDB_SHARDING_TASK_PAUSED_WATCHER = "xdb.sharding.task.paused.watcher";
    private static final String FIRE_TASK_PAUSED_LOCK_KEY = "/xdbsharding/fire_task_paused";

    public static void registTaskPausedListener(final ShardTaskPausedListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    ShardTaskPausedInfo ti = ShardTaskPausedListener.fromKey((String)newValue);
                    l.onReceiveChangeTableMV(ti);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        ShardTaskPausedNotifier.observeChange(XDB_SHARDING_TASK_PAUSED_WATCHER, listener);
    }

    public static void fireLimitTaskPaused(String entityName, boolean paused) {
        String value = ShardTaskPausedListener.currentKey(entityName, paused);
        log.info("fireLimitTablePaused " + entityName + " " + value);
        ShardTaskPausedNotifier.fireLimit(FIRE_TASK_PAUSED_LOCK_KEY, XDB_SHARDING_TASK_PAUSED_WATCHER, value);
    }
}

