/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.splittingread;

import kd.bos.db.splittingread.RW;
import kd.bos.db.splittingread.RWContext;
import kd.bos.db.splittingread.RWContextImpl;
import kd.bos.db.splittingread.RWLogger;
import kd.bos.db.splittingread.RWManager;
import kd.bos.db.splittingread.RWScenes;
import kd.bos.db.splittingread.ThreadReadWriteContext;

public class RWImpl
implements RW {
    @Override
    public RWContext create(String key) {
        return this.create(RWScenes.custom, key);
    }

    @Override
    public boolean hasExist() {
        return ThreadReadWriteContext.get() != null;
    }

    @Override
    public RWContext createWriteFirst() {
        RWLogger.info("create force write first context", new Object[0]);
        return this.newContext("master_first");
    }

    @Override
    public RWContext create(RWScenes scenes, String key) {
        RWLogger.info("create rw context: scenes={} key={}", new Object[]{scenes, key});
        try {
            RWManager rwManager = RWManager.getInstance();
            String mode = rwManager.getMode(scenes, key);
            if (mode != null) {
                return this.newContext(mode);
            }
        }
        catch (Exception exception) {
            RWLogger.getLogger().error("cause an exception when get readwrite config, " + exception.getMessage());
            RWLogger.getLogger().error((Throwable)exception);
        }
        return this.newContext("master_first");
    }

    private RWContext newContext(String modeStr) {
        return new RWContextImpl(modeStr);
    }
}

