/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.splittingread;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.splittingread.RWConfigService;
import kd.bos.db.splittingread.RWLogger;
import kd.bos.db.splittingread.RWManager;
import kd.bos.db.splittingread.RWScenes;
import kd.bos.db.splittingread.RWScenesConfigService;
import kd.bos.db.splittingread.SlaveDBCheckResult;
import kd.bos.db.splittingread.SplittingReadConfig;
import kd.bos.db.splittingread.SplittingReadWriteMode;

public class RWManagerStandardImpl
implements RWManager {
    private final RWConfigService configService;
    private final RWScenesConfigService scenesConfigService;
    private static final RWManagerStandardImpl instance = new RWManagerStandardImpl();

    public static RWManagerStandardImpl getInstance() {
        return instance;
    }

    public RWManagerStandardImpl() {
        this.configService = new RWConfigService();
        this.scenesConfigService = new RWScenesConfigService();
    }

    public RWManagerStandardImpl(RWConfigService configService, RWScenesConfigService scenesConfigService) {
        this.configService = configService;
        this.scenesConfigService = scenesConfigService;
    }

    private boolean isGlobalConfigEnable() {
        boolean enable = SplittingReadConfig.isGlobalEnable();
        if (!enable) {
            RWLogger.info("global config disable, please check parameter: [db.splittingread.enable].", new Object[0]);
        }
        return enable;
    }

    private boolean isAccountConfigEnable() {
        boolean enable = SplittingReadConfig.isAccountEnable();
        if (!enable) {
            RWLogger.info("account config disable, please check current datacenter config.", new Object[0]);
        }
        return enable;
    }

    @Override
    public String getMode(RWScenes scenes, String key) {
        if (!this.isGlobalConfigEnable()) {
            return "master_first";
        }
        if (!this.isAccountConfigEnable()) {
            return "master_first";
        }
        String mode = this.configService.getModel(scenes, key);
        if (mode != null) {
            return mode;
        }
        mode = this.scenesConfigService.getModel(scenes, key);
        if (mode != null) {
            return mode;
        }
        mode = this.getFromWhiteList(scenes, key);
        return mode;
    }

    private String getFromWhiteList(RWScenes scenes, String key) {
        String mode = "master_first";
        switch (scenes) {
            case billlist: 
            case report: {
                if (!SplittingReadConfig.isEnableReadWrite(scenes.name())) break;
                mode = "slave_first";
                break;
            }
            default: {
                if (!SplittingReadConfig.isEnableReadWrite(key)) break;
                mode = "slave_first";
            }
        }
        return mode;
    }

    @Override
    public SlaveDBCheckResult getCheckSlaveDBResult(RWScenes scenes, String key, String routeKey) {
        SlaveDBCheckResult result = new SlaveDBCheckResult();
        result.setGlobalEnable(this.isGlobalConfigEnable());
        result.setCurrentAccountEnable(this.isAccountConfigEnable());
        this.getSlaveDBList(result, routeKey);
        this.getSlaveDBAvailable(result, routeKey);
        String modeString = this.configService.getModel(scenes, key);
        SplittingReadWriteMode mode = SplittingReadWriteMode.fromConfig(modeString);
        if (mode != null) {
            result.setConfigInSlaveFirst(mode == SplittingReadWriteMode.read);
        }
        if ((mode = SplittingReadWriteMode.fromConfig(modeString = this.scenesConfigService.getModel(scenes, key))) != null) {
            result.setScenesSlaveFirst(mode == SplittingReadWriteMode.read);
        }
        if ((mode = SplittingReadWriteMode.fromConfig(modeString = this.getFromWhiteList(scenes, key))) != null) {
            result.setWhiteListHasSlaveFirst(mode == SplittingReadWriteMode.read);
        }
        return result;
    }

    private void getSlaveDBList(SlaveDBCheckResult checkResult, String routeKey) {
        RequestContextInfo rc = RequestContextInfo.get();
        List<DBConfig> dbConfigList = DBConfig.loadFromDataCenter(rc.getTenantId(), routeKey, rc.getAccountId(), true);
        if (dbConfigList == null || dbConfigList.isEmpty()) {
            checkResult.setSlaveInfoList(Collections.emptyList());
            return;
        }
        ArrayList<SlaveDBCheckResult.DatabaseInfo> databaseInfoList = new ArrayList<SlaveDBCheckResult.DatabaseInfo>(dbConfigList.size());
        for (DBConfig config : dbConfigList) {
            if (!config.isReadOnly()) continue;
            SlaveDBCheckResult.DatabaseInfo info = new SlaveDBCheckResult.DatabaseInfo();
            info.setHost(config.getIp());
            info.setPort(config.getPort());
            info.setLoadFactor(config.getLoadFactor());
            databaseInfoList.add(info);
        }
        checkResult.setSlaveInfoList(databaseInfoList);
    }

    private void getSlaveDBAvailable(SlaveDBCheckResult result, String routeKey) {
        RequestContextInfo rc = RequestContextInfo.get();
        boolean available = DataSourceFactory.isReadOnlyDBAvailable(rc.getTenantId(), routeKey, rc.getAccountId());
        result.setSlaveDBAvailable(available);
    }

    @Override
    public void invalidConfigCache() {
        this.configService.invalidCache();
    }

    @Override
    public void invalidScenesCache() {
        this.scenesConfigService.invalidCache();
    }
}

