/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk;

import java.util.Collection;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.temptable.pk.PKTempTableReleaseListener;
import kd.bos.db.temptable.pk.PKTempTableUtil;
import kd.bos.db.temptable.pk.table.PKTempTableFactory;

public interface PKTempTable
extends AutoCloseable {
    public String getTable();

    public void insert(Collection<? extends Object> var1);

    public void clear();

    public void release();

    @Override
    default public void close() {
        this.release();
    }

    public long getTimeout();

    public void setTimeout(long var1);

    public long getTimeoutRemaining();

    public boolean isTimeout();

    public boolean isReleased();

    public void addReleaseListener(PKTempTableReleaseListener var1);

    public static DBRoute getRealRouteKey(DBRoute route) {
        String archiveRouteKey = ArchiveRoute.getMapRoute(route.getRouteKey());
        LogicArchiveRoute logicArchiveRote = LogicArchiveRoute.of(archiveRouteKey);
        DBRoute realRoute = DBRoute.of(logicArchiveRote.getRealArchiveKey());
        PKTempTableUtil.log.info("pktemptable route: src={} archive={} logicArchive={} real={}", new Object[]{route, archiveRouteKey, logicArchiveRote, realRoute});
        return realRoute;
    }

    public static PKTempTable createPKLong(DBRoute route) {
        return PKTempTableFactory.createPKLong(PKTempTable.getRealRouteKey(route));
    }

    public static PKTempTable createPKString(DBRoute route) {
        return PKTempTableFactory.createPKString(PKTempTable.getRealRouteKey(route));
    }

    public static PKTempTable createPKBigString(DBRoute route) {
        return PKTempTableFactory.createPKBigString(PKTempTable.getRealRouteKey(route));
    }
}

