/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.cleaner;

import java.util.List;
import java.util.Map;
import kd.bos.context.OperationContextCreator;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.pool.PKTempTablePooledObject;
import kd.bos.db.temptable.pk.registry.PKTempTableRegistry;
import kd.bos.db.temptable.pk.registry.db.DBInstanceClear;
import kd.bos.db.temptable.pk.registry.db.PKTempTableDBRegistry;
import kd.bos.db.temptable.pk.stats.PKTempTableStats;
import kd.bos.dlock.DLock;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ThreadLocals;

public class PKTempTableDBRegistryClearService
implements Runnable {
    private static final Log log = LogFactory.getLog(PKTempTableDBRegistryClearService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (PKTempTableConfig.getRegistryType() != PKTempTableRegistry.RegistryType.db) {
                throw new RuntimeException("PKTempTableDBRegistryClearService start error,current instance:" + Instance.getInstanceId() + " PKTempTableRegistryType not DB.");
            }
            OperationContextCreator.getOrCreateForBos();
            int maxScanTimesOneRound = 3;
            if (PKTempTableConfig.getClearStartupDelayMinute() > 0) {
                Thread.sleep((long)PKTempTableConfig.getClearStartupDelayMinute() * 1L * 60L * 1000L);
            }
            PKTempTableDBRegistry reg = (PKTempTableDBRegistry)PKTempTableRegistry.get();
            try {
                while (true) {
                    DLock lock;
                    if ((lock = DLock.create((String)"/db/pktemptable/clear_service/").fastMode()).tryLock()) {
                        long remainingTime;
                        long ts = System.currentTimeMillis();
                        try {
                            for (DBInstanceClear item : reg.getCrashInstancesClear()) {
                                item.clear();
                                this.crashNodeStatistics(item.getInstanceMapTableObjects());
                            }
                        }
                        catch (Exception e) {
                            log.warn("Clear pkTempTable error.", (Throwable)e);
                        }
                        finally {
                            long wait = (long)PKTempTableConfig.getClearIntervalMinute() * 1L * 60L * 1000L / 3L - (System.currentTimeMillis() - ts);
                            if (wait > 0L) {
                                Thread.sleep(wait);
                            }
                            lock.unlock();
                            ThreadLocals.release();
                        }
                        if ((remainingTime = (long)PKTempTableConfig.getClearIntervalMinute() * 1L * 60L * 1000L - (System.currentTimeMillis() - ts)) <= 0L) continue;
                        Thread.sleep(remainingTime);
                        continue;
                    }
                    Thread.sleep((long)PKTempTableConfig.getClearIntervalMinute() * 1L * 60L * 1000L);
                }
            }
            catch (InterruptedException e) {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void crashNodeStatistics(Map<String, List<PKTempTablePooledObject>> instanceMapTableObjects) {
        Map<String, Integer[]> crashNode = PKTempTableStats.getCrashNode();
        for (Map.Entry<String, List<PKTempTablePooledObject>> entry : instanceMapTableObjects.entrySet()) {
            String instanceId = entry.getKey();
            List<PKTempTablePooledObject> releaseObjs = entry.getValue();
            if (crashNode.containsKey(instanceId)) {
                Integer[] longs = crashNode.get(instanceId);
                Integer[] ints = new Integer[2];
                Integer[] integerArray = longs;
                ints[0] = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                ints[1] = longs[1] + releaseObjs.size();
                crashNode.put(instanceId, ints);
                continue;
            }
            crashNode.put(instanceId, new Integer[]{1, releaseObjs.size()});
        }
    }
}

