/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.cleaner;

import kd.bos.context.OperationContextCreator;
import kd.bos.db.pktemptable.utils.PKTempTableThreadUtils;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.registry.PKTempTableRegistry;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PKTempTableDBRegistryHeartbeatService
implements Runnable {
    private static final Log log = LogFactory.getLog(PKTempTableDBRegistryHeartbeatService.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        OperationContextCreator.getOrCreateForBos();
        String instanceId = Instance.getInstanceId();
        try {
            Thread.sleep(PKTempTableConfig.getHeartbeatMinute() * 60 * 1000);
        }
        catch (InterruptedException e) {
            log.warn("DBInstanceTable instanceId:" + instanceId + " delay start PKTempTableDBRegistryHeartbeatService fail,thread interrupted.");
            return;
        }
        while (true) {
            PKTempTableThreadUtils.resetThread();
            long startMillisecond = System.currentTimeMillis();
            long endMillisecond = startMillisecond + (long)(PKTempTableConfig.getHeartbeatMinute() * 60 * 1000);
            try {
                PKTempTableRegistry.get().heartbeat();
                long current = System.currentTimeMillis();
                if (current >= endMillisecond) {
                    log.warn("DBInstanceTable DBRegistryHeartbeat one time use " + (current - startMillisecond) + " ms");
                    continue;
                }
                Thread.sleep(endMillisecond - current);
                continue;
            }
            catch (Exception e) {
                log.warn("DBInstanceTable update instance:" + instanceId + " lastHeartbeatTime exception,msg=" + e.getMessage(), (Throwable)e);
                if (e instanceof InterruptedException) return;
                continue;
            }
            break;
        }
    }
}

