/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.config;

import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.db.temptable.pk.registry.PKTempTableRegistry;
import kd.bos.util.ConfigurationUtil;

public final class PKTempTableConfig {
    private static final PKTempTableRegistry.RegistryType registryType = PKTempTableRegistry.RegistryType.db;
    private static boolean nopool = false;
    private static boolean tempWithIndex = true;
    private static int clearIntervalMinute = 30;
    private static int clearSetartupDelayMiniute = 1;
    private static int timeoutMinute = 120;
    private static boolean mysqlUseMemoryEngine = false;
    private static boolean mysqlUseLoadInfile = true;
    private static boolean sqlServerUseBulk = false;
    private static int heartbeatMinute = 40;
    private static int timeoutCycleInterval = 3;
    private static boolean clearOldDBRegistryInstance = false;
    private static boolean testOnBorrow = false;
    private static final int BIG_STRING_LENGTH = Integer.parseInt(System.getProperty("db.pktemp.big_string_length", "80"));
    private static final int PK_STRING_LENGTH = Integer.parseInt(System.getProperty("db.pktemp.pk_string_length", "40"));
    private static final int RELEASE_THREAD = Integer.parseInt(System.getProperty("db.pktemp.release_thread", "3"));
    private static final int MAX_TOTAL = Integer.parseInt(System.getProperty("db.pktemp.pool.maxTotal", "200"));
    private static final int MAX_IDLE = Integer.parseInt(System.getProperty("db.pktemp.pool.maxIdle", "20"));
    private static final int MIN_IDLE = Integer.parseInt(System.getProperty("db.pktemp.pool.minIdle", "4"));
    private static final int MAX_WAIT = Integer.parseInt(System.getProperty("db.pktemp.pool.maxWait", "30000"));
    private static final boolean MYSQL_USE_DB_DEFAULT_CHARSET = Boolean.parseBoolean(System.getProperty("db.pktemp.mysql_use_db_default_charset", "true"));
    private static final String MYSQL_TABLE_CHARSET = System.getProperty("db.pktemp.mysql_table_charset", "utf8mb4");
    private static final String MYSQL_TABLE_COLLATE = System.getProperty("db.pktemp.mysql_table_collate", "utf8mb4_unicode_ci");
    public static final String DLOCK_KEY_CLEAR_SERVICE = "/db/pktemptable/clear_service/";
    public static final String DLOCK_KEY_INIT_INSTANCE_SUFFIX = "/db/pktemptable/init_instance_suffix/";

    public static PKTempTableRegistry.RegistryType getRegistryType() {
        return registryType;
    }

    public static boolean isNoPool() {
        return nopool;
    }

    public static boolean isTempWithIndex() {
        return tempWithIndex;
    }

    public static int getClearIntervalMinute() {
        if (clearIntervalMinute <= 0) {
            clearIntervalMinute = 30;
        }
        return clearIntervalMinute;
    }

    public static int getClearStartupDelayMinute() {
        return clearSetartupDelayMiniute;
    }

    public static int getTimeoutMinute() {
        return timeoutMinute;
    }

    public static boolean isMySQLUseMemoryEngine() {
        return mysqlUseMemoryEngine;
    }

    public static boolean isMySQLUseLoadInfile() {
        return DataSourceURLs.isAllowLoadLocalInfile() && mysqlUseLoadInfile;
    }

    public static int getBigStringLength() {
        return BIG_STRING_LENGTH;
    }

    public static int getReleaseThread() {
        return RELEASE_THREAD;
    }

    public static int getPoolMaxTotal() {
        return MAX_TOTAL;
    }

    public static int getPoolMaxIdle() {
        return MAX_IDLE;
    }

    public static int getPoolMinIdle() {
        return MIN_IDLE;
    }

    public static int getPoolMaxWait() {
        return MAX_WAIT;
    }

    public static int getHeartbeatMinute() {
        return heartbeatMinute;
    }

    public static int getTimeoutCycleInterval() {
        return timeoutCycleInterval;
    }

    public static boolean isClearOldDBRegistryInstance() {
        return clearOldDBRegistryInstance;
    }

    public static int getLogStackThreshold() {
        return kd.bos.db.pktemptable.config.PKTempTableConfig.getLogStackThreshold();
    }

    public static boolean isSqlServerUseBulk() {
        return sqlServerUseBulk;
    }

    public static boolean isMysqlUseDbDefaultCharset() {
        return MYSQL_USE_DB_DEFAULT_CHARSET;
    }

    public static String getMysqlTableCharset() {
        return MYSQL_TABLE_CHARSET;
    }

    public static String getMysqlTableCollate() {
        return MYSQL_TABLE_COLLATE;
    }

    public static boolean isTestOnBorrow() {
        return testOnBorrow;
    }

    public static int getPkStringLength() {
        if (PK_STRING_LENGTH < 32) {
            return 32;
        }
        return PK_STRING_LENGTH;
    }

    public static boolean isDmEnableTableVariable() {
        return kd.bos.db.pktemptable.config.PKTempTableConfig.isDmEnableTableVariable();
    }

    public static boolean isPgUseCopyIn() {
        return kd.bos.db.pktemptable.config.PKTempTableConfig.isPgUseCopyIn();
    }

    public static boolean isPgUseUnloggedTable() {
        return kd.bos.db.pktemptable.config.PKTempTableConfig.isPgUseUnloggedTable();
    }

    static {
        ConfigurationUtil.observeBoolean((String)"db.pktemp.nopool", (boolean)nopool, v -> {
            nopool = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.pktemp.withindex", (boolean)tempWithIndex, v -> {
            tempWithIndex = v;
        });
        ConfigurationUtil.observeInteger((String)"db.pktemp.clearservice.startup_delay_minute", (int)clearSetartupDelayMiniute, v -> {
            clearSetartupDelayMiniute = v;
        });
        ConfigurationUtil.observeInteger((String)"db.pktemp.clearservice.interval_minute", (int)clearIntervalMinute, v -> {
            clearIntervalMinute = v;
        });
        ConfigurationUtil.observeInteger((String)"db.pktemp.timeout_minute", (int)timeoutMinute, v -> {
            timeoutMinute = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.pktemp.mysql_use_memory_engine", (boolean)mysqlUseMemoryEngine, v -> {
            mysqlUseMemoryEngine = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.pktemp.mysql_use_load_infile", (boolean)mysqlUseLoadInfile, v -> {
            mysqlUseLoadInfile = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.pktemp.sql_server_use_bulk", (boolean)sqlServerUseBulk, v -> {
            sqlServerUseBulk = v;
        });
        ConfigurationUtil.observeInteger((String)"db.pktemp.heartbeat_minute", (int)heartbeatMinute, v -> {
            heartbeatMinute = v;
        });
        ConfigurationUtil.observeInteger((String)"db.pktemp.timeout_cycle_interval", (int)timeoutCycleInterval, v -> {
            timeoutCycleInterval = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.pktemp.clear_old_db_registry_instance", (boolean)clearOldDBRegistryInstance, v -> {
            clearOldDBRegistryInstance = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.pktemp.test_on_borrow", (boolean)testOnBorrow, v -> {
            testOnBorrow = v;
        });
    }
}

