/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.pool;

import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;

public final class PKTempTablePooledObject {
    private final RequestContextInfo rc;
    private final DBRoute route;
    private final String table;

    public PKTempTablePooledObject(RequestContextInfo rc, DBRoute route, String table) {
        this.rc = rc;
        this.route = route;
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public DBRoute getRoute() {
        return this.route;
    }

    public RequestContextInfo getRequestContextInfo() {
        return this.rc;
    }

    public String toSerializedString() {
        return this.rc.getTenantId() + '#' + this.rc.getAccountId() + '#' + this.route.getRouteKey() + '#' + this.table;
    }

    public String toString() {
        return this.toSerializedString();
    }

    public static PKTempTablePooledObject fromSerializedString(String s) {
        String[] ss = s.split("#");
        if (ss.length != 4) {
            throw new IllegalArgumentException(s);
        }
        RequestContextInfo rc = new RequestContextInfo(ss[0], ss[1]);
        DBRoute route = DBRoute.of(ss[2]);
        String table = ss[3];
        return new PKTempTablePooledObject(rc, route, table);
    }
}

