/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.pool;

import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.temptable.pk.PKTempTableUtil;
import kd.bos.db.temptable.pk.pool.PKTempTablePooledObject;
import kd.bos.db.temptable.pk.registry.PKTempTableRegistry;
import kd.bos.db.temptable.pk.table.PKTempTableType;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public final class PKTempTablePooledObjectFactory
implements PooledObjectFactory<PKTempTablePooledObject> {
    private final RequestContextInfo rc;
    private final DBRoute route;
    private final PKTempTableType type;

    public PKTempTablePooledObjectFactory(RequestContextInfo rc, DBRoute route, PKTempTableType type) {
        this.rc = rc;
        this.route = route;
        this.type = type;
    }

    public PooledObject<PKTempTablePooledObject> makeObject() throws Exception {
        try (AutoCloseable ac = this.rc.setupThreadRequestContext();){
            String pkTempTable = PKTempTableUtil.genPKTableName(this.type);
            PKTempTablePooledObject obj = new PKTempTablePooledObject(this.rc, this.route, pkTempTable);
            PKTempTableRegistry.get().regist(obj);
            PKTempTableUtil.createPKTable(this.route, this.type, pkTempTable);
            DefaultPooledObject defaultPooledObject = new DefaultPooledObject((Object)obj);
            return defaultPooledObject;
        }
    }

    public void destroyObject(PooledObject<PKTempTablePooledObject> p) throws Exception {
        this.destroyObject((PKTempTablePooledObject)p.getObject());
    }

    void destroyObject(PKTempTablePooledObject pooledObject) throws Exception {
        String pkTempTable = pooledObject.getTable();
        try (AutoCloseable ac = pooledObject.getRequestContextInfo().setupThreadRequestContext();){
            PKTempTableUtil.dropPKTable(pkTempTable, this.route);
            PKTempTableRegistry.get().unRegist(pooledObject);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean validateObject(PooledObject<PKTempTablePooledObject> p) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void activateObject(PooledObject<PKTempTablePooledObject> p) throws Exception {
    }

    public void passivateObject(PooledObject<PKTempTablePooledObject> p) throws Exception {
    }
}

