/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.registry.db;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.extension.DBExtensionsRegister;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.pool.PKTempTablePooledObject;
import kd.bos.db.temptable.pk.registry.db.DBRegistryInstanceHeartbeat;
import kd.bos.db.temptable.pk.registry.db.IntBase36Coder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dlock.DLock;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.DisCardUtil;
import kd.bos.xdb.hint.NoShardingHint;

final class DBInstanceTable {
    private static final Log log = LogFactory.getLog((String)"DB");
    private static final String INSTANCE_ID = Instance.getInstanceId();
    private static final DBRoute DB_ROUTE = DBRoute.basedata;
    private static final String TABLE_NAME = "t_pktemp_instance";

    DBInstanceTable() {
    }

    private static String wrapNoShardingSQL(String sql) {
        return NoShardingHint.genNoShardingSQL((String)sql);
    }

    /*
     * Exception decompiling
     */
    private static <T> T call(Account account, Call<T> call) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String calcTableNameSuffix() {
        String sql = DBInstanceTable.wrapNoShardingSQL("select FTableSuffix from t_pktemp_instance");
        List list = DB.query(DB_ROUTE, sql, null, rs -> {
            ArrayList<String> ret = new ArrayList<String>(16);
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            return ret;
        });
        if (list.isEmpty()) {
            return "0";
        }
        HashSet<Integer> used = new HashSet<Integer>(list.size() + 1);
        used.add(IntBase36Coder.toInt("L"));
        for (String suffix : list) {
            used.add(IntBase36Coder.toInt(suffix));
        }
        for (int i = 0; i <= Integer.MAX_VALUE; ++i) {
            if (used.contains(i)) continue;
            return IntBase36Coder.toString(i);
        }
        throw new RuntimeException("Crazy, table t_pktemp_instance has full!");
    }

    static String addCurrentInstance(Account account) {
        try {
            String sqlCreatePK = DBInstanceTable.wrapNoShardingSQL("EXEC P_ALTERPK 'PK_pktemp_instance', 't_pktemp_instance', 'FInstanceId', '1'");
            return DBInstanceTable.call(account, () -> {
                while (!DB.exitsTable(DB_ROUTE, TABLE_NAME)) {
                    DLock dlock = DLock.create((String)("/db/pktemptable/init_instance_suffix/_createtable/" + account.getAccountId())).fastMode();
                    if (!dlock.tryLock(10000L)) continue;
                    try {
                        if (DB.exitsTable(DB_ROUTE, TABLE_NAME)) continue;
                        String sql_create_table = DBInstanceTable.wrapNoShardingSQL("create table t_pktemp_instance (FInstanceId varchar(120), FTableSuffix varchar(6), FCreateTime datetime, FLastHeartbeatTime datetime)");
                        DB.execute(DB_ROUTE, sql_create_table);
                        String sql_create_table_index = DBInstanceTable.wrapNoShardingSQL("CREATE UNIQUE INDEX IX_t_pktemp_instance ON t_pktemp_instance(FInstanceId)");
                        DB.execute(DB_ROUTE, sql_create_table_index);
                        if (!PKTempTableConfig.isTableCreateWithPk()) continue;
                        DB.execute(DB_ROUTE, sqlCreatePK);
                    }
                    finally {
                        dlock.unlock();
                    }
                }
                DLock dLock = DLock.create((String)("/db/pktemptable/init_instance_suffix/_upgrade_table/" + account.getAccountId())).fastMode();
                if (dLock.tryLock()) {
                    try {
                        if (!DBInstanceTable.existColumn(DB_ROUTE, TABLE_NAME, "FLastHeartbeatTime")) {
                            DB.execute(DB_ROUTE, "ALTER TABLE t_pktemp_instance ADD (FLastHeartbeatTime DATETIME)");
                        }
                        if (PKTempTableConfig.isTableCreateWithPk()) {
                            try {
                                DB.execute(DB_ROUTE, sqlCreatePK);
                            }
                            catch (Exception ignored) {
                                DisCardUtil.discard();
                            }
                        }
                    }
                    finally {
                        dLock.unlock();
                    }
                }
                String sql_query_exists_suffix = DBInstanceTable.wrapNoShardingSQL("select FTableSuffix from t_pktemp_instance where FInstanceId=?");
                String suffix = DB.query(DB_ROUTE, sql_query_exists_suffix, new Object[]{INSTANCE_ID}, rs -> {
                    if (rs.next()) {
                        return rs.getString(1);
                    }
                    return null;
                });
                if (suffix != null) {
                    return suffix;
                }
                DLock dlock = DLock.create((String)("/db/pktemptable/init_instance_suffix/_calc/" + account.getAccountId())).fastMode();
                if (dlock.tryLock(60000L)) {
                    try {
                        suffix = DBInstanceTable.calcTableNameSuffix();
                        String sql_add_current_instance = DBInstanceTable.wrapNoShardingSQL("insert into t_pktemp_instance(FInstanceId,FTableSuffix,FCreateTime,FLastHeartbeatTime) values(?,?,?,?)");
                        DB.execute(DB_ROUTE, sql_add_current_instance, new Object[]{INSTANCE_ID, suffix, new Date(), new Date()});
                        String string = suffix;
                        return string;
                    }
                    finally {
                        dlock.unlock();
                    }
                }
                throw new RuntimeException("acquire lock timeout: " + dlock);
            });
        }
        catch (Exception e) {
            String msg = "DBInstanceTable addCurrentInstance " + account.getTenantId() + '.' + account.getAccountId() + '.' + INSTANCE_ID + " failed: " + e.getMessage();
            log.error(msg, (Throwable)e);
            return msg;
        }
    }

    static boolean existColumn(DBRoute dbRoute, String tableName, String columnName) {
        String sql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '" + tableName + "' AND KSQL_COL_NAME ='" + columnName + "'";
        return DB.query(dbRoute, sql, ResultSet::next);
    }

    static List<String> getInstances(Account account) {
        try {
            return DBInstanceTable.call(account, () -> {
                String sql = DBInstanceTable.wrapNoShardingSQL("select FInstanceId from t_pktemp_instance");
                return DB.query(DB_ROUTE, sql, null, rs -> {
                    ArrayList<String> ret = new ArrayList<String>(16);
                    while (rs.next()) {
                        ret.add(rs.getString(1));
                    }
                    return ret;
                });
            });
        }
        catch (Exception e) {
            log.error("DBInstanceTable getInstances " + account.getTenantId() + '.' + account.getAccountId() + " failed: " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    static void removeInstance(Account account, String instanceId) {
        try {
            DBInstanceTable.call(account, () -> {
                String sql = DBInstanceTable.wrapNoShardingSQL("delete from t_pktemp_instance where FInstanceId=?");
                DB.execute(DB_ROUTE, sql, new Object[]{instanceId});
                log.info("DBInstanceTable remove crash instance: " + instanceId + " ,tenant=" + account.getTenantId() + " account=" + account.getAccountId() + '.');
                return null;
            });
        }
        catch (Exception e) {
            log.error("DBInstanceTable removeInstance " + account.getTenantId() + '.' + account.getAccountId() + '.' + instanceId + " failed: " + e.getMessage(), (Throwable)e);
        }
    }

    static List<PKTempTablePooledObject> getInstanceExistsPKTempTable(Account account, String instanceId) {
        try {
            return DBInstanceTable.call(account, () -> {
                if (!DB.exitsTable(DB_ROUTE, TABLE_NAME)) {
                    return Collections.emptyList();
                }
                String tableSuffix = DBInstanceTable.queryTableNameSuffix(instanceId);
                if (tableSuffix == null) {
                    return Collections.emptyList();
                }
                String suffix = ("_" + tableSuffix).toUpperCase();
                ArrayList<PKTempTablePooledObject> all = new ArrayList<PKTempTablePooledObject>(32);
                String likeName = ("TEMP_%" + suffix).toUpperCase();
                String sql = "SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE KSQL_TABNAME like '" + likeName + "'";
                HashSet<String> sharingIdSet = new HashSet<String>(16);
                for (DBInstance dbInstance : account.getDBInstanceList()) {
                    for (DBConfig config : DBExtensionsRegister.getDBConfigs(account.getTenantId(), dbInstance.getRouteKey(), account.getAccountId(), false)) {
                        if (config.isReadOnly() || !sharingIdSet.add(config.getSharingId())) continue;
                        DBRoute curRoute = DBRoute.of(dbInstance.getRouteKey());
                        List list = DB.query(curRoute, sql, null, rs -> {
                            ArrayList<String> ret = new ArrayList<String>();
                            while (rs.next()) {
                                String name = rs.getString(1).toUpperCase();
                                if (!name.endsWith(suffix)) continue;
                                ret.add(name);
                            }
                            return ret;
                        });
                        for (String table : list) {
                            PKTempTablePooledObject obj = new PKTempTablePooledObject(RequestContextInfo.get(), curRoute, table);
                            all.add(obj);
                        }
                    }
                }
                return all;
            });
        }
        catch (Exception e) {
            log.error("DBInstanceTable getInstanceExistsPKTempTable " + account.getTenantId() + '.' + account.getAccountId() + '.' + instanceId + " failed: " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    static void updateInstanceHeartbeatTime(Account account) {
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ac = rc.setupThreadRequestContext();
             TXHandle h = TX.requiresNew();){
            String sql = "UPDATE t_pktemp_instance SET FLastHeartbeatTime=? WHERE FInstanceId=?";
            DB.update(DB_ROUTE, sql, new Object[]{new Date(), INSTANCE_ID});
        }
        catch (Exception e) {
            log.warn("DBInstanceTable update lastHeartbeatTime " + account.getTenantId() + '.' + account.getAccountId() + '.' + INSTANCE_ID + " failed:" + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    static List<DBRegistryInstanceHeartbeat> getDBRegistryInstances(Account account) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String queryTableNameSuffix(String instanceId) {
        String sql = DBInstanceTable.wrapNoShardingSQL("select FTableSuffix from t_pktemp_instance where FInstanceId=?");
        return DB.query(DB_ROUTE, sql, new Object[]{instanceId}, rs -> {
            if (rs.next()) {
                return rs.getString(1);
            }
            return null;
        });
    }

    private static /* synthetic */ List lambda$getDBRegistryInstances$8(ResultSet rs) throws Exception {
        ArrayList<DBRegistryInstanceHeartbeat> instances = new ArrayList<DBRegistryInstanceHeartbeat>(16);
        while (rs.next()) {
            String instanceId = rs.getString("FInstanceId");
            Timestamp heartTime = rs.getTimestamp("FLastHeartbeatTime");
            instances.add(new DBRegistryInstanceHeartbeat(instanceId, heartTime == null ? null : heartTime.toLocalDateTime()));
        }
        return instances;
    }

    @FunctionalInterface
    private static interface Call<T> {
        public T call();
    }
}

