/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.registry.db;

import java.util.HashMap;
import java.util.Map;

final class IntBase36Coder {
    private static final char[] CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final int RADIX = CHARS.length;
    private static final Map<Character, Integer> KV_MAP = new HashMap<Character, Integer>(RADIX);

    IntBase36Coder() {
    }

    static int toInt(String s) {
        int v = 0;
        for (char ch : s.toCharArray()) {
            Integer iv = KV_MAP.get(Character.valueOf(ch));
            if (iv == null) {
                throw new IllegalArgumentException(s + " has unreconized character: " + ch);
            }
            v = v * RADIX + iv;
        }
        return v;
    }

    static String toString(int v) {
        StringBuilder sb = new StringBuilder(6);
        do {
            int mod = v % RADIX;
            sb.append(CHARS[mod]);
        } while ((v /= RADIX) != 0);
        return sb.reverse().toString();
    }

    static {
        int i = 0;
        for (char ch : CHARS) {
            KV_MAP.put(Character.valueOf(ch), i++);
        }
    }
}

