/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.temptable.pk.PKTempTableAccountUtils;
import kd.bos.db.temptable.pk.pool.PKTempTablePool;
import kd.bos.db.temptable.pk.pool.PKTempTablePoolFactory;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.hint.NoShardingHint;

public class PKTempTableStats {
    private static final Log log = LogFactory.getLog((String)"DB");
    private static final String SQL_QUERY_INSTANCE = "select FInstanceId,FTableSuffix,FCreateTime from t_pktemp_instance";
    private static AtomicLong borrowed = new AtomicLong(0L);
    private static AtomicLong released = new AtomicLong(0L);
    private static AtomicLong unRelease = new AtomicLong(0L);
    private static AtomicInteger uncheck = new AtomicInteger(0);
    private static int timeout;
    private static Map<String, Integer[]> crashNode;

    public static long getBorrowed() {
        return borrowed.get();
    }

    public static void incBorrowed() {
        borrowed.incrementAndGet();
    }

    public static void decBorrowed() {
        borrowed.decrementAndGet();
    }

    public static long getReleased() {
        return released.get();
    }

    public static void incReleased() {
        released.incrementAndGet();
    }

    public static void decReleased() {
        released.decrementAndGet();
    }

    public static long getUnRelease() {
        return unRelease.get();
    }

    public static void incUnReleased() {
        unRelease.incrementAndGet();
    }

    public static void decUnReleased() {
        unRelease.decrementAndGet();
    }

    public static int getUncheck() {
        return uncheck.get();
    }

    public static void incUncheck() {
        uncheck.incrementAndGet();
    }

    public static void decUncheck() {
        uncheck.decrementAndGet();
    }

    public static int getPoolTotal() {
        int total = 0;
        List<PKTempTablePool> list = PKTempTablePoolFactory.getPools();
        for (PKTempTablePool pkTempTablePool : list) {
            total += pkTempTablePool.getTotalNum();
        }
        return total;
    }

    public static void incTimeout() {
        ++timeout;
    }

    public static int getTimeout() {
        return timeout;
    }

    public static Map<String, Integer[]> getCrashNode() {
        return crashNode;
    }

    public static int getUsedInPool() {
        int total = 0;
        List<PKTempTablePool> list = PKTempTablePoolFactory.getPools();
        for (PKTempTablePool pkTempTablePool : list) {
            total += pkTempTablePool.getActiveNum();
        }
        return total;
    }

    public static List<Map<String, Object>> getPKTempInstanceInDB() {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(20);
        List<Account> accountList = PKTempTableAccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : accountList) {
            RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
            try {
                AutoCloseable ac = rc.setupThreadRequestContext();
                Throwable throwable = null;
                try {
                    TXHandle h = TX.requiresNew();
                    Throwable throwable2 = null;
                    try {
                        DB.query(DBRoute.basedata, NoShardingHint.genNoShardingSQL((String)SQL_QUERY_INSTANCE), rs -> {
                            if (rs.next()) {
                                HashMap<String, String> retMap = new HashMap<String, String>(3);
                                retMap.put("instanceId", rs.getString("FInstanceId"));
                                retMap.put("tableSuffix", rs.getString("FTableSuffix"));
                                retMap.put("createTime", rs.getString("FCreateTime"));
                                ret.add(retMap);
                            }
                            return null;
                        });
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable2 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        h.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (ac == null) continue;
                    if (throwable != null) {
                        try {
                            ac.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ac.close();
                }
            }
            catch (Exception e) {
                log.error("query PKTempInstance error," + account.toString() + ",error massage: " + e.getMessage());
            }
        }
        return ret;
    }

    static {
        crashNode = new HashMap<String, Integer[]>(8);
    }
}

